# The complete web development bootcamp

![Alt text](FullStack.jpg?raw=true "certificate")

## Resources

https://www.appbrewery.co/p/web-development-course-resources

## Projects

- Project 1 : Using HTML created personal site - https://sdkdeepa.github.io/resume/

- Project 2 : Intro to CSS - https://sdkdeepa.github.io/profile/

- Project 2 final : HTML, CSS and Bootstrap - https://sdkdeepa.github.io/udemy-bootstrap/

- Project 3 : Dice game - JS and DOM methods - https://sdkdeepa.github.io/dice

- Project 4 : Drum kit - JS Keyboard events - https://sdkdeepa.github.io/drumming/

- Project 5 : Simon Game - JS and jQuery - https://sdkdeepa.github.io/Simon-Game-Jquery/

- Project 6: BMI Calculator - Node.js and Express.js. This project using API methods such as GET and POST to calculate the BMI

<p align="center">
  <img width="460" height="300" src="https://github.com/sdkdeepa/Udemy-web-bootcamp/blob/master/Calculator.gif">
</p>

---

- Project 7: Weather App - Node.js and Express.js. This project uses external weather API to make GET call to get the weather data after a POST request is sent.

<p align="center">
  <img width="460" height="300" src="https://github.com/sdkdeepa/Udemy-web-bootcamp/blob/master/WeatherApp.gif">
</p>

- Project 8: Newsletter Sign up - Html, CSS, Bootstrap, JS, Nodejs, express,API, NPM, Nodemon, body-parser etc - https://shrouded-river-17694.herokuapp.com/

- Project 9 and 10: Todo List app - Continuation of Todo list app v2. Added get, post and delete routes. You can now create and delete todo list for today and for custom list. Custom list can be added to the home route (ex: /work). Using MongoDB Altas cloud database the data is collected. Hosted application through Heroku.
  Check out: https://tranquil-earth-77166.herokuapp.com/

- Project 11: Multipage Personal Blog Website - Created a multi page personal blog application using HTML, CSS, Bootstrap, JS, Node.js, Express.js, body-parser, API, EJS, Heroku, Mongoose, MogoDB Altas cloud cluster. Checkout: https://morning-brook-32061.herokuapp.com/

### Example of wireframing a project

- Project 2. wireframing TinDog.png

## Topics covered

HTML, CSS, JavaScript, Bootstrap 4, DOM & DOM Manipulation, jQuery, Node.js, Express, React EJS, body-parser, nodemon, lodash, MongoDB, MongoDB Atlas,
mongoose, mongoose-encryption, dotenv, md5, bcrypt, passport, passport-local, passport-local-mongoose, passport-google-path20, mongoose-findorcreate, express-session, API, JSON, Authentication, Mailchimp API, Build REST API from scratch, Heroku.

### Section 9: Introduction to JavaScript ES6

- 116-117: Challenge: Changing Casing in Text
- 118: Basic Arithmetic and Modulo Operator in Javascript
- 121-122: Functions Part 1: Challenge - The Karel Robot
- 124: Functions Part 2: Parameters and Arguments

#### Section 10: Intermediate JavaScript

- 131: Random Number Generation in Javascript: Building a Love Calculator
- 132: Control Statements: Using If-Else Conditionals & Logic
- Coding Exercise 5: BMI Calculator Advanced (IF/ELSE)
- Coding Exercise 6: Leap Year
- 138: Adding Elements and Intermediate Array Techniques

### Section 12: Boss Level Challenge 1 - The Dicee Game

- Create an External JS File
- Add Dice Images
- Create a Random Number
- Change both img to a Random Dice
- Change both img Elements
- Change the Title to Display a Winner

### Section 13: Advanced JavaScript and DOM Manipulation

- 172: Higher Order Function Challenge

### Section 14: Drum Kit

- 171: Adding Event Listners to a Button
- 174: How to Play Sounds on a Website
- 176: How to Use Switch Statements in JavaScript
- 179: Using Keyboard Event Listeners to Check for Key Presses
- 181: Adding Animation to Websites

### Section 15: Boss Level Challenge 2 - The Simon Game

- Add JS and jQuery
- Create a New Pattern
- Show the Sequence to the User with Animations and Sounds
- Check Which Button is Pressed
- Add Sounds to Button Clicks
- Add Animations to User Clicks
- Start the Game
- Check the User's Answer Against the Game Sequence
- Game Over
- Restart the Game

### Section 19: Express.js with Node.js

- 241: Creating Our First Server with Express
- 242: Handling Requests and Responses: the GET Request
- 244: Understanding and Working with Routes
- 246: Calculator Challenge Setup
- 248: Responding to Requests with HTML Files
- 249: Processing Post Requests with Body Parser
- 250: BMI Routing Challenge

### Section 20: APIs - Application Programming Interfaces

- 258: Making GET Requests with the Node HTTPS Module
- 259: How to Parse JSON
- 260: Using Express to Render a Website with Live API Data
- 261: Using Body Parser to Parse POST Requests to the Server
  Project: Weather Project

### Section 21: Newsletter Signup

- 263: Setting up the Sign Up Page
- 264: Posting Data to Mailchimp's Servers via their API
- 265: Adding Success and Failure Pages
- 266: Deploying Your Server with Heroku

Project: https://shrouded-river-17694.herokuapp.com/

### Section 22: EJS

- 282: Templates? Why Do We Need Templates?
- 283: Creating Your First EJS Template
- 284: Running Code Inside the EJS Template
- 285: Passing Data from Your Webpage to Your Server
- 287: Adding Pre-Made CSS Stylesheets to Your Website
- 288: Understanding Templating vs Layouts
- 289: Understanding Node Module Exports: How to Pass Functions and Data between Files

### Section 23: Boss Level Challenge 3 - Blog Website

- Get Home route and add content to home.ejs
- Pass data from homeStartingContent to home.ejs
- Add header and footer partials to home.ejs
- Moved header and footer to partials folder
- Add About and Contact routes, pass content to about and contact.ejs
- Add nav href to header
- Add compose form and POST route
- Add text fields to compose form and use bootstrap
- Create JS object for post
- Push post into posts array
- Add posts to render array
- Loop through all posts
- Refactor for loop to use forEach
- Render each post onto Home
- Add express routing parameters /posts/:blogPost
- Loop through posts array to check if it matches title in url
- Add lodash and use \_.lowerCase on titles
- Separate page for each blog post
- Truncate post body on Home page to 100 characters
- Add Read More to posts

### Section 27: Mongoose

- 357: Introduction to Mongoose
- 358: Reading from Your Database with Mongoose
- 359: Data Validation with Mongoose
- 360: Updating and Deleting Data Using Mongoose
- 361: Establishing Relationships and Embedding Documents using Mongoose

### Section 28: Putting Everything Together

- 364: Take ToDoList Project to the Next Level and Connect it with Mongoose
- 365: Rendering Database Items into the ToDoList App
- 366: Adding New Items to our ToDoList Database
- 367: Deleting Items from our ToDoList Database
- 368: Creating Custom Lists using Express Route Parameters
- 369: Adding New Items to the Custom ToDoLists
- 370: Revisiting Lodash and Deleting Items from Custom ToDo Lists

### Section 29 - Deploying Your Web Application

- 374: How to Deploy Web Apps with a Database
- 374: How to Setup MongoDB Atlas
- 375: Deploying An App with a Database to Heroku

Folder: Project 9 and 10: Todo List
https://tranquil-earth-77166.herokuapp.com/

### Section 30 - Boss Level Challenge 4 - Blog Website Upgrade

- 381: Save Composed Posts with MongoDB
- 382: Get Home Page to Render the Posts
- 383: Redirect to Home Page after save() is completed with no errors
- 384: Render correct blog post based on post \_id

Folder: Project 11: Blog website completed
https://morning-brook-32061.herokuapp.com/

### Section 31 - Build Your Own RESTful API From Scratch

- 389: Set Up Server Challenge
- 391: GET All Articles
- 392: POST a New Article
- 393: Delete All Articles
- 394: Chained Route Handlers Using Express
- 395: GET a Specific Article
- 396: PUT a Specific Article
- 397: PATCH a Specific Article
- 398: DELETE a Specific Article

Folder: Wiki-API

## Section 32 - Authentication & Security

- 403: Getting Set Up
- 404: Level 1 - Register Users with Username and Password
- 406: Level 2 - Database Encryption
- 407: Using Environment Variables to Keep Secrets Safe
- 408: Level 3 - Hashing Passwords
- 410: Level 4 - Salting and Hashing Passwords with bcrypt
- 412: Level 5 - Using Passport.js to Add Cookies and Sessions
- 413a: Level 6 - OAuth 2.0 & How to Implement Sign In with Google
- 413b: Level 6 - OAuth 2.0 with Facebook
- 414: Letting Users Submit Secrets

Folder: Secrets

### Section 33 - React.js

- 422: JSX Code Practice
- 423: JavaScript Expressions in JSX & ES6 Template Literals
- 424: JavaScript Expressions in JSX Practice
- 425: Attributes and Styling React Elements
- 426: Inline Styling for React Elements
- 427: React Styling Practice
- 428: React Components
- 429: React Components Practice
- 431: JavaScript ES6 Import, Export and Modules Practice
- 434: Keeper App Project - Part 1
- 436: React Props
- 437: React Props Practice
- 438: React DevTools - https://990sq.csb.app/
- 439: Mapping Data to Components - https://0lrqy.csb.app/
- 440: Mapping Data to Components Practice - https://1kzup.csb.app/
- 441: JavaScript ES6 Map/Filter/Reduce
- 442: JavaScript ES6 Arrow functions
- 443: Keeper App Project - Part 2
- 444: React Conditional Rendering with the Ternary Operator & AND Operator
- 445: Conditional Rendering Practice - https://pr7ow.csb.app/
- 447: React Hooks - useState
- 448: useState Hook Practice
- 449: JavaScript ES6 Object & Array Destructuring
- 450: JavaScript ES6 Destructuring Challenge
- 451: Event Handling in React
- 452: React Forms
- 454: Changing Complex State
- 455: Changing Complex State Practice
- 456: JavaScript ES6 Spread Operator
- 457: JavaScript ES6 Spread Operator Practice
- 458: Managing a Component Tree
- 459: Managing a Component Tree Practice
- 460: Keeper App Project - Part 3
- 461: React Dependencies & Styling the Keeper App - https://pbt9b.csb.app/

### Tools used

- codepen
- Atom
- Postman
- Hyper terminal
- Visual Studio Code
- https://codesandbox.io/
