# System
Use cases for managing Windows 10 clients / Windows Server 2016 or later

+ [Clear-SysMOldProfiles.ps1](./Clear-SysMOldProfiles.ps1)

  Remove old profiles on computer 

+ [Clear-SysMProfile.ps1](./Clear-SysMProfile.ps1)

  Remove profile on computer

+ [Clear-SysMRecycleBin.ps1](./Clear-SysMRecycleBin.ps1)

  Clears recycle bin on computer

+ [Clear-SysMWindowsUpdate.ps1](./Clear-SysMWindowsUpdate.ps1)

  Clear Windows Update. Removes the system folder SoftwareDistribution 

+ [Get-SysMComputerInfos.ps1](./Get-SysMComputerInfos.ps1)

  Gets a consolidated object of system and operating system properties

+ [Get-SysMHotFixes.ps1](./Get-SysMHotFixes.ps1)

  Gets the hotfixes that have been applied to the local and remote computer

+ [Get-SysMInstalledPrograms.ps1](./Get-SysMInstalledPrograms.ps1)

  Get list of installed programs on local or remote computer

+ [Get-SysMPSVersion.ps1](./Get-SysMPSVersion.ps1)

  Gets the powershell version on local or remote computer

+ [Get-SysMTimeZone.ps1](./Get-SysMTimeZone.ps1)

  Gets the current time zone or a list of available time zones

+ [Get-SysMUpdateLog.ps1](./Get-SysMUpdateLog.ps1)

  Merges Windows Update .etl files into a single log file

+ [Get-SysMUserProfiles.ps1](./Get-SysMUserProfiles.ps1)

  Gets the Active Directory user profiles on the computer

+ [Remove-SysMUserProfile.ps1](./Remove-SysMUserProfile.ps1)

  Removes the profile of the user

+ [Restart-SysMComputer.ps1](./Restart-SysMComputer.ps1)

  Restarts ("reboots") the operating system computers

+ [Set-SysMAutologon.ps1](./Set-SysMAutologon.ps1)

  Enable or disable Windows Auto Logon  
  
+ [Set-SysMAutoUpdate.ps1](./Set-SysMAutoUpdate.ps1)

  Enable or disable Automatic Updates for Windows Update 
  
+ [Set-SysMCredSSP.ps1](./Set-SysMCredSSP.ps1)

  Enable or disable Credential Security Support Provider (CredSSP) authentication on a computer

+ [Set-SysMExplorerSettings .ps1](./Set-SysMExplorerSettings.ps1)

  Changes the explorer settings for one or all logged on users

+ [Set-SysMSearchSettings .ps1](./Set-SysMSearchSettings.ps1)

  Sets the group policy search settings on the computer

+ [Set-SysMTimeZone.ps1](./Set-SysMTimeZone.ps1)

  Sets the system time zone to a specified time zone

+ [Set-SysMUAC.ps1](./Set-SysMUAC.ps1)

  Configure User Account Control

+ [Stop-SysMComputer.ps1](./Stop-SysMComputer.ps1)

  Stops (shuts down) the computers.

+ [Test-SysMConnection.ps1](./Test-SysMConnection.ps1)

  Sends ICMP echo request packets ("pings") to one or more computers