# Windows Server Backup
Use cases for managing Windows 2016 Server or later

+ [Get-SysMWBBackupFiles.ps1](./Get-SysMWBBackupFiles.ps1)

  Gets the list of backup file specifications associated with a backup policy

+ [Get-SysMWBBackupSets.ps1](./Get-SysMWBBackupSets.ps1)

  Gets backups for a server from a location that you specify

+ [Get-SysMWBBackupTarget.ps1](./Get-SysMWBBackupTarget.ps1)

  Gets backup storage locations that you specified as part of a backup policy

+ [Get-SysMWBDisks.ps1](./Get-SysMWBDisks.ps1)

  Gets a list of internal and external disks that are online for the local computer

+ [Get-SysMWBFiles.ps1](./Get-SysMWBFiles.ps1)

  Gets the list of backup file specifications associated with a backup policy

+ [Get-SysMWBJobs.ps1](./Get-SysMWBJobs.ps1)

  Gets the current backup operation

+ [Get-SysMWBPolicy.ps1](./Get-SysMWBPolicy.ps1)

  Gets the current backup policy for the computer

+ [Get-SysMWBSchedule.ps1](./Get-SysMWBSchedule.ps1)

  Gets the current schedule for backups

+ [Get-SysMWBSummary.ps1](./Get-SysMWBSummary.ps1)

  Gets the history of backup operations on the computer

+ [Get-SysMWBVolume.ps1](./Get-SysMWBVolume.ps1)

  Gets a list of internal and external disks that are online for the local computer

+ [Remove-SysMWBBackupSet.ps1](./Remove-SysMWBBackupSet.ps1)

  Removes a backup from a target catalog, a system catalog, or both

+ [Remove-SysMWBFile.ps1](./Remove-SysMWBFile.ps1)

  Removes a file from a backup policy

+ [Remove-SysMWBPolicy.ps1](./Remove-SysMWBPolicy.ps1)

  Removes the backup policy  

+ [Set-SysMWBBackupSchedule.ps1](./Set-SysMWBBackupSchedule.ps1)

  Sets the current schedule for backups

+ [Set-SysMWBBackupTarget.ps1](./Set-SysMWBBackupTarget.ps1)

  Sets a backup target to a backup policy

+ [Set-SysMWBPolicy.ps1](./Set-SysMWBPolicy.ps1)

  Sets the backup policy for scheduled backups
  
+ [Start-SysMWBBackup.ps1](./Start-SysMWBBackup.ps1)

  Starts a async one-time backup operation

+ [Start-SysMWBFileRecovery.ps1](./Start-SysMWBFileRecovery.ps1)

  Starts a file recovery operation

+ [Start-SysMWBVolumeRecovery.ps1](./Start-SysMWBVolumeRecovery.ps1)

  Starts a volume recovery operation

+ [Stop-SysMWBJob.ps1](./Stop-SysMWBJob.ps1)

  Stops the current backup or recovery job