# Manage Printers

> Note: The use of the scripts requires the PowerShell Module PrintManagement.

+ [Add-PrtMPrinterConnection.ps1](./Add-PrtMPrinterConnection.ps1)

  Adds connection to network-based printer

+ [Export-PrtMPrinters.ps1](./Export-PrtMPrinters.ps1)

  Export printers in a csv file

+ [Get-PrtMPrintConfiguration.ps1](./Get-PrtMPrintConfiguration.ps1)

  Gets the configuration information of a printer

+ [Get-PrtMPrinterErrors.ps1](./Get-PrtMPrinterErrors.ps1)

  Get the error values of the printer from the specified computer

+ [Get-PrtMPrinterErrorsList.ps1](./Get-PrtMPrinterErrorsList.ps1)

  Get the error values of all local printer from the specified computer

+ [Get-PrtMPrinterPermissions.ps1](./Get-PrtMPrinterPermissions.ps1)

  Get the permissions of the printer from the specified computer

+ [Get-PrtMPrinters.ps1](./Get-PrtMPrinters.ps1)

  Get local printers from the specified computer

+ [Get-PrtMPrinterStatus.ps1](./Get-PrtMPrinterStatus.ps1)

  Get the status of the printer from the specified computer

+ [Get-PrtMPrinterStatusList.ps1](./Get-PrtMPrinterStatusList.ps1)

  Get the status of all local printer from the specified computer

+ [Import-PrtMPrinters.ps1](./Import-PrtMPrinters.ps1)

  Creates print ports and printers asyncron from csv file to a print server

+ [Initialize-PrtMPrintTestpage.ps1](./Initialize-PrtMPrintTestpage.ps1)

  Initialize the print of a test page on the printer

+ [New-PrtMPrinter.ps1](./New-PrtMPrinter.ps1)

  Create print port and printer

+ [Remove-PrtMPrinter.ps1](./Remove-PrtMPrinter.ps1)

  Removes a printer from the specified computer

+ [Remove-PrtMPrinterPermissions.ps1](./Remove-PrtMPrinterPermissions.ps1)

  Removes the permissions from the printer from the specified computer

+ [Rename-PrtMPrinter.ps1](./Rename-PrtMPrinter.ps1)

  Renames the specified printer

+ [Set-PrtMPrintConfiguration.ps1](./Set-PrtMPrintConfiguration.ps1)

  Sets the configuration information for the specified printer

+ [Set-PrtMPrinter.ps1](./Set-PrtMPrinter.ps1)

  Sets the properties of an existing printer

+ [Set-PrtMPrinterPermissions.ps1](./Set-PrtMPrinterPermissions.ps1)

  Sets the permissions to the printer from the specified computer
