# Action Pack for Windows File Server, Distributed File System and Windows Storage Management
Use cases for managing file servers, file & folder access rights, reports and more.<br>
Also managing storages, disks, partitions and volumes

## [Distributed File System](./DFS)
+ Get, set, move, add, remove DFS folder
+ Get, set, add, remove DFS namespace
+ Get, set, add, remove root target
+ Get, grant, revoke, remove DFS folder accounts
+ Get, set server configuration

## [Manage Disks](./Disks)

+ Get drive capacities
+ Get, clear, initialize disk
+ Get, set, format, repair, optimize volume 
+ Get, set, create, resize, remove partition
+ Get, set storage setting

## [Manage Folder and files](./FolderAndFiles)

+ Get/set permissions on a folder or file
+ Add/rename/move/remove an folder
+ Test path exists
+ List of folders or files
+ List with number and sizes of folders or files

## [Manage Shares](./Shares)

+ Add/copy/remove a share
+ Get/set properties of a share
+ Set/remove permissions on a share
+ List of shares
+ List of share sizes
+ List of share permissions

## [Reports](./_REPORTS_)
+ Generate report with shares, share sizes, share permissions
+ Generate report with objects, object permissions
+ Generate report with volume infos, drive capacities, disk infos, partition objects
+ Generate a report with the largest sub folders below the start folder

## [Queries](./_QUERY_)

+ Search a list of objects
+ Search the names, numbers unique ids from disks
+ Search drive letters
+ Search partition numbers
+ Search the shares on the computer