# Manage Disks

+ [Clear-FilMDisk.ps1](./Clear-FilMDisk.ps1)

  Cleans a disk by removing all partition information and un-initializing it, erasing all data on the disk

+ [Format-FilMVolume.ps1](./Format-FilMVolume.ps1)

  Formats a existing volumes or a new volume on an existing partition

+ [Get-FilMCapacities.ps1](./Get-FilMCapacities.ps1)

  Retrieves the disk capacities from the computer

+ [Get-FilMDisk.ps1](./Get-FilMDisk.ps1)

  Gets one or more disks visible to the operating system

+ [Get-FilMPartition.ps1](./Get-FilMPartition.ps1)

  Returns a list of all partition objects visible on the disk

+ [Get-FilMStorageSetting.ps1](./Get-FilMStorageSetting.ps1)
  
  Gets a StorageSettings object

+ [Get-FilMVolume.ps1](./Get-FilMVolume.ps1)

  Gets the specified volume object or all volume objects

+ [Initialize-FilMDisk.ps1](./Initialize-FilMDisk.ps1)

  Initializes a RAW disk for first time use, enabling the disk to be formatted and used to store data

+ [New-FilMPartition.ps1](./New-FilMPartition.ps1)

  Creates a new partition on an existing Disk object

+ [Optimize-FilMVolume.ps1](./Optimize-FilMVolume.ps1)

  Optimizes a volume

+ [Remove-FilMPartition.ps1](./Remove-FilMPartition.ps1)

  Deletes the specified Partition object on an existing disk and any underlying Volume objects

+ [Repair-FilMVolume.ps1](./Repair-FilMVolume.ps1)

  Performs repairs on a volume

+ [Resize-FilMPartition.ps1](./Resize-FilMPartition.ps1)

  Resizes a partition and the underlying file system

+ [Set-FilMPartition.ps1](./Set-FilMPartition.ps1)

  Sets attributes of a partition

+ [Set-FilMStorageSetting.ps1](./Set-FilMStorageSetting.ps1)

  Adjusts or configures current storage settings of the StorageSetting object

+ [Set-FilMVolume.ps1](./Set-FilMVolume.ps1)

  Sets or changes the file system label of an existing volume