# Distributed File System

> Note: The use of the scripts requires the PowerShell Module DFSN

+ [Get-DFSFolder.ps1](./Get-DFSFolder.ps1)

  Gets folder in a DFS namespace

+ [Get-DFSFolderAccess.ps1](./Get-DFSFolderAccess.ps1)

  Gets permissions for a DFS namespace folder

+ [Get-DFSFolderTarget.ps1](./Get-DFSFolderTarget.ps1)

  Gets settings for targets of a DFS namespace folder

+ [Get-DFSRoot.ps1](./Get-DFSRoot.ps1)

  Gets settings for DFS namespaces

+ [Get-DFSRootTarget.ps1](./Get-DFSRootTarget.ps1)

  Gets settings for root targets of a DFS namespace

+ [Get-DFSServerConfiguration.ps1](./Get-DFSServerConfiguration.ps1)

  Gets settings for targets of a DFS namespace folder

+ [Grant-DFSFolderAccess.ps1](./Grant-DFSFolderAccess.ps1)

  Grants permissions to user or group to access a DFS namespace folder

+ [Move-DFSFolder.ps1](./Move-DFSFolder.ps1)

  Moves or renames a DFS namespace folder

+ [New-DFSFolder.ps1](./New-DFSFolder.ps1)

  Creates a folder in a DFS namespace

+ [New-DFSFolderTarget.ps1](./New-DFSFolderTarget.ps1)

  Adds a target to a DFS namespace folder

+ [New-DFSRoot.ps1](./New-DFSRoot.ps1)

  Creates a DFS namespace

+ [New-DFSRootTarget.ps1](./New-DFSRootTarget.ps1)

  Adds a root target to a DFS namespace

+ [Remove-DFSFolder.ps1](./Remove-DFSFolder.ps1)

  Removes a DFS namespace folder

+ [Remove-DFSFolderAccess.ps1](./Remove-DFSFolderAccess.ps1)

  Removes users and groups from the ACL for a folder in a DFS namespace

+ [Remove-DFSFolderTarget.ps1](./Remove-DFSFolderTarget.ps1)

  Removes a target for a DFS namespace folder

+ [Remove-DFSRoot.ps1](./Remove-DFSRoot.ps1)

  Removes a DFS namespace

+ [Remove-DFSRootTarget.ps1](./Remove-DFSRootTarget.ps1)

  Removes a target for a DFS namespace root

+ [Revoke-DFSFolderAccess.ps1](./Revoke-DFSFolderAccess.ps1)

  Revokes permissions for users to access and enumerate the contents of a DFS namespace folder

+ [Set-DFSFolder.ps1](./Set-DFSFolder.ps1)

  Changes settings for a DFS namespace folder
  
+ [Set-DFSFolderTarget.ps1](./Set-DFSFolderTarget.ps1)

  Changes settings for a target of a DFS namespace folder

+ [Set-DFSRoot.ps1](./Set-DFSRoot.ps1)

  Changes settings for a DFS namespace

+ [Set-DFSRootTarget.ps1](./Set-DFSRootTarget.ps1)

  Changes settings for a root target of a DFS namespace

+ [Set-DFSServerConfiguration.ps1](./Set-DFSServerConfiguration.ps1)

  Changes settings for a DFS namespace root server


  ## [Queries](./_QUERY_)

+ Search accounts from folder
+ Search folders and folder targets
+ Search namespaces
+ Search root targets