# Action Pack for Skype for Business  
Use cases for managing Skype for Business 

> Note: The use of the scripts requires the PowerShell Module SkypeOnlineConnector

## [Members](./Members)

+ Get/set user
+ Get user acp, Pstn settings

## [Resources](./Resources)

+ Get/update/remove auto attendant
+ Get holidays, status, supported language, supported time zone, information of auto attendant

## [Online](./Online)

+ Get directory tenant, Sip domain, Pstn usage
+ Get online user, online user voicemail settings
+ Get online voice route, online voice user, online voicemail user settings
+ Manage online application
+ Manage online dial in conferencing
+ Manage Location Information Service
+ Manage online telephonenumber

## [Policies](./Policies)

+ Get dial out policy, voice policy, voice routing policy, broadcast meeting policy, client policy, graph policy
+ Get cloud meeting policy, conferencing policy, external access policy, external user communication policy
+ Get hosted voice mail policy, IP phone policy, mobility policy, presence policy, user services policy
+ Get online voice mail policy, online voice routing policy

## [Settings](./Settings)

+ Get configuration of phone, broadcast meeting, meeting configuration settings, OAuth configuration settings
+ Get call line identity, call queue, dial plan, hosting provider, hunt group
+ Get voice normalization rule, notification configuration settings, privacy configuration settings

## [Teams](./Teams)

+ Get calling policy, call park policy, channels policy, emergency calling policy
+ Get messaging policy, broadcast policy, meeting policy
+ Get configuration of clients, broadcast, guest messaging, guest meeting, guest calling, upgrade

## [Tenants](./Tenants)

+ Get tenant
+ Get tenant dial plan, public provider, update time window
+ Get configuration of federation, licensing, hybrid, migration

## [Reports](./_REPORTS_)

+ Generate report with Auto Attendants, Auto Attendants supported languages, Auto Attendants time zones, Auto Attendants tenant informations
+ Generate report with dial plan, online dial in conferencing languages and user infos
+ Generate report with online sip domains, online users, online telephone number inventory types
+ Generate report with teams calling policy, teams channels policy, teams client configuration, teams IP phone policy, teams meeting broadcast policy
+ Generate report with teams meeting configuration, teams meeting policy, teams messaging policy
+ Generate report with teams upgrade policy, teams video interop service policy
+ Generate report with tenants, tenant federation configuration, tenant public provider
+ Generate report with users, users Acps, voice normalization rule 

## [Queries](./_QUERY_)

+ Get group ids of the teams

## [Library](./_LIB_)

+ Open/remove Skype for Business online session 