# Online

> Note: The use of the scripts requires the PowerShell Module SkypeOnlineConnector.


+ [Get-SFBOnlineApplicationEndpoint.ps1](./Get-SFBOnlineApplicationEndpoint.ps1)
    
  Fetch the application endpoints for a tenant

+ [Get-SFBOnlineApplicationInstanceAssociation.ps1](./Get-SFBOnlineApplicationInstanceAssociation.ps1)

  Returns information about the associations setup in your organization  

+ [Get-SFBOnlineApplicationInstanceAssociationStatus.ps1](./Get-SFBOnlineApplicationInstanceAssociationStatus.ps1)

  Returns the provisioning status for the associations you have setup in your organization 

+ [Get-SFBOnlineDialInConferencingBridge.ps1](./Get-SFBOnlineDialInConferencingBridge.ps1)

  View the settings on an audio conferencing bridge that is used when Microsoft is the audio conferencing provider

+ [Get-SFBOnlineDialInConferencingLanguagesSupported.ps1](./Get-SFBOnlineDialInConferencingLanguagesSupported.ps1)

  View the list of languages that are supported when an organization uses Microsoft as the dial-in audio conferencing provider  

+ [Get-SFBOnlineDialinConferencingServiceNumber.ps1](./Get-SFBOnlineDialinConferencingServiceNumber.ps1)

  Returns all of the default dial-in service numbers that are assigned to an Office 365 audio conferencing bridge

+ [Get-SFBOnlineDialinConferencingTenantConfiguration.ps1](./Get-SFBOnlineDialinConferencingTenantConfiguration.ps1)

  Retrieve the tenant level configuration for dial-in conferencing

+ [Get-SFBOnlineDialinConferencingTenantSettings.ps1](./Get-SFBOnlineDialinConferencingTenantSettings.ps1)

  Retrieve the global setting for the tenant administrator's organization

+ [Get-SFBOnlineDialinConferencingUser.ps1](./Get-SFBOnlineDialinConferencingUser.ps1)

  Returns the properties and settings of users that are enabled for dial-in conferencing and are using Microsoft as their PSTN conferencing provider

+ [Get-SFBOnlineDialinConferencingUserInfo.ps1](./Get-SFBOnlineDialinConferencingUserInfo.ps1)

  Returns the properties and settings of users that are enabled for dial-in conferencing and are using Microsoft or third-party provider as their PSTN conferencing provider

+ [Get-SFBOnlineDirectoryTenant.ps1](./Get-SFBOnlineDirectoryTenant.ps1)

  Retrieve a tenant and associated parameters from the Business Voice Directory

+ [Get-SFBOnlineEnhancedEmergencyServiceDisclaimer.ps1](./Get-SFBOnlineEnhancedEmergencyServiceDisclaimer.ps1)

  Determine whether your organization has accepted the terms and conditions of enhanced emergency service

+ [Get-SFBOnlineLisCivicAddress.ps1](./Get-SFBOnlineLisCivicAddress.ps1)

  Retrieve information about existing emergency civic addresses defined in the Location Information Service (LIS.) 

+ [Get-SFBOnlineLisLocation.ps1](./Get-SFBOnlineLisLocation.ps1)

  Retrieve information on previously defined locations in the Location Information Service (LIS.)

+ [Get-SFBOnlinePstn​Usage.ps1](./Get-SFBOnline​PstnUsage.ps1)

  Returns information about online public switched telephone network (PSTN) usage records used in your tenant
  
+ [Get-SFBOnlineSipDomain.ps1](./Get-SFBOnline​SipDomain.ps1)

  Returns the status of sip domains in the Office 365 tenant

+ [Get-SFBOnline​​TelephoneNumber.ps1](./Get-SFBOnline​​TelephoneNumber.ps1)

  Retrieve telephone numbers from the Business Voice Directory 

+ [Get-SFBOnline​​TelephoneNumberAvailableCount.ps1](./Get-SFBOnline​​TelephoneNumberAvailableCount.ps1)

  Retrieve the total telephone numbers your organization is licensed to acquire

+ [Get-SFBOnline​​TelephoneNumberInventoryAreas.ps1](./Get-SFBOnline​​TelephoneNumberInventoryAreas.ps1)

  Retrieve the geographical areas where specified inventory types are supported

+ [Get-SFBOnline​​TelephoneNumberInventory​Countries.ps1](./Get-SFBOnline​​TelephoneNumberInventory​Countries.ps1)

  Retrieve a list of countries with telephone number inventories by specified region and telephone number inventory types

+ [Get-SFBOnline​​TelephoneNumberInventoryCountries.ps1](./Get-SFBOnline​​TelephoneNumberInventoryCountries.ps1)

  Retrieve a list of countries with telephone number inventories by specified region and telephone number inventory types

+ [Get-SFBOnline​​TelephoneNumberInventoryRegions.ps1](./Get-SFBOnline​​TelephoneNumberInventoryRegions.ps1)

  Retrieve the regions where specified inventory types are supported

+ [Get-SFBOnline​​TelephoneNumberInventoryTypes.ps1](./Get-SFBOnline​​TelephoneNumberInventoryTypes.ps1)

  Retrieve the telephone number inventory types that are defined

+ [Get-SFBOnlineTelephoneNumberReservationsInformation.ps1](./Get-SFBOnlineTelephoneNumberReservationsInformation.ps1)

  Retrieve information about the total number of telephone numbers which can reserved per session, and the maximum active reservations per session

+ [Get-SFBOnline​​User.ps1](./Get-SFBOnline​​User.ps1)

  Returns information about users who have accounts homed on Skype for Business Online

+ [Get-SFBOnline​Voicemail​User​Settings.ps1](./Get-SFBOnline​Voicemail​User​Settings.ps1)

  Returns information about online voicemail user settings of a specific user

+ [Get-SFBOnlineVoiceRoute.ps1](./Get-SFBOnlineVoiceRoute.ps1)

  Returns information about the online voice routes configured for use in your tenant

+ [Get-SFBOnlineVoiceUser.ps1](./Get-SFBOnlineVoiceUser.ps1)

  Retrieve a voice user's telephone number and location