# Action Pack for SharePoint Online 
Use cases for managing SharePoint Online  

> Note: The use of the scripts requires the PowerShell Module Microsoft.Online.SharePoint.PowerShell

## [Apps](./Apps)

+ Get app info, app errors

## [Common](./Common)

+ Get/remove theme
+ Hide default themes
+ Enable com site
+ Add/get/set/remove Org assets library
+ Add/remove Sdn provider
+ Get/set/remove news site
+ Add/get/remove public Cdn origins
+ Get migration package
+ Add/get/remove geo administrator
+ Configure/administrate migration
+ Configure multi geo tenant
+ Migration job administration

## [Sites](./Sites)

+ Add/get/set/repair/test/upgrade/restore/remove a site
+ Add/get/set/remove a site group
+ Add/get/invoke/set/remove a site design, get design run status
+ Get/grant/revoke site design rights
+ Add/get/set/unregister/register Hub site
+ Grant/revoke hub site design rights
+ Add/get/remove a site design task
+ Get/restore/remove deleted sites
+ Check status of a site or group move
+ Add/get/remove geo administrator
+ Set Office 365 group

## [Tenant](./Tenant)

+ Get/set a tenant
+ Add/move/remove a datacenter
+ Add/get/enable/remove Cdn origin
+ Get/set Cdn policies
+ Configure Cdn properties
+ Configure service principal permissions
+ Configure replication

## [Users](./Users)

+ Add/get/set/remove a user
+ Get/remove a external users
+ Get one drive location
+ Remove user info, user profile
+ Check status of a user or site move across geo locations
+ Export user query logs, user profile, user info

## [Reports](./_REPORTS_)

+ Generate report with app infos, errors
+ Generate report with cross geo users, moved users
+ Generate report with tenant infos, Cdn policies, log entries
+ Generate report with users, sites, site groups, hub sites, deleted sites, external users
+ Generate report with Public Cdn origins, Organizational news site, geo administrator, Geo storage quotas

## [Queries](./_QUERY_)

+ Search site collections

## [Library](./_LIB_)

+ Connect/disconnect SharePoint Online