﻿# Reports

> Note: The use of the scripts requires the PowerShell Module Microsoft.Online.SharePoint.PowerShell.

+ [Get-SPOApp​Errors_Html.ps1](./Get-SPOApp​Errors_Html.ps1)

  Generates a report with application errors

+ [Get-SPOApp​Info_Html.ps1](./Get-SPOApp​Info_Html.ps1)

  Generates a report with all the installed applications from an external marketplace or from the App Catalog that contain Name in their application names or the installed application with mentioned ProductId

+ [Get-SPOCrossGeoMovedUsers_Html.ps1](./Get-SPOCrossGeoMovedUsers_Html.ps1)

  Generates a report with the SharePoint Online user (or users) that had been moved

+ [Get-SPOCrossGeoUsers_Html.ps1](./Get-SPOCrossGeoUsers_Html.ps1)

  Generates a report with the SharePoint Online users in a multi-geo tenant that match the criteria

+ [Get-SPODeletedSite_Html.ps1](./Get-SPODeletedSite_Html.ps1)

  Generates a report with all deleted site collections from the Recycle Bin

+ [Get-SPOExternalUser_Html.ps1](./Get-SPOExternalUser_Html.ps1)

  Generates a report with external users in the tenant

+ [Get-SPOGeoAdministrator_Html.ps1](./Get-SPOGeoAdministrator_Html.ps1)

  Generates a report with the SharePoint Online user or security group accounts 
  with global administrative privileges in the current Multi-Geographics tenant

+ [Get-SPOGeoStorageQuota_Html.ps1](./Get-SPOGeoStorageQuota_Html.ps1)

  Generates a report with the storage quota on a multi-geo tenant

+ [Get-SPOHubSite_Html.ps1](./Get-SPOHubSite_Html.ps1)

  Generates a report with hub sites or hub site information

+ [Get-SPOOrg​News​Site_Html.ps1](./Get-SPOOrg​News​Site_Html.ps1)

  Generates a report with URLs of all the configured organizational news sites. Requires Tenant administrator permissions

+ [Get-SPOPublicCdnOrigins_Html.ps1](./Get-SPOPublicCdnOrigins_Html.ps1)

  Generates a report with a list of CDN Origins in your SharePoint Online Tenant

+ [Get-SPOSiteGroup_Html.ps1](./Get-SPOSiteGroup_Html.ps1)

  Generates a report with the groups on the specified site collection

+ [Get-SPOSites_Html.ps1](./Get-SPOSites_Html.ps1)

  Generates a report with one or more sites

+ [Get-SPOTenant_Html.ps1](./Get-SPOTenant_Html.ps1)

  Generates a report with SharePoint Online organization properties

+ [Get-SPOTenantCdnPolicies_Html.ps1](./Get-SPOTenantCdnPolicies_Html.ps1)

  Generates a report with the public or private Policies applied on your SharePoint Online Tenant

+ [Get-SPOTenantLogEntry_Html.ps1](./Get-SPOTenantLogEntry_Html.ps1)

  Generates a report with SharePoint Online company logs

+ [Get-SPOUser_Html.ps1](./Get-SPOUser_Html.ps1)

  Generates a report with the SharePoint Online user or security group accounts that match a given search criteria