# Users

> Note: The use of the scripts requires the PowerShell Module Microsoft.Online.SharePoint.PowerShell.


+ [Add-SPOUser.ps1](./Add-SPOUser.ps1)
    
  Adds an existing Office 365 user or an Office 365 security group to a SharePoint group

+ [Export-SPOQueryLogs.ps1](./Export-SPOQueryLogs.ps1)
    
  Returns all deleted site collections from the Recycle Bin

+ [Export-SPOUserInfo.ps1](./Export-SPOUserInfo.ps1)
    
  Export user information from site user information list

+ [Export-SPOUserProfile.ps1](./Export-SPOUserProfile.ps1)
    
  Export user profile data to csv file

+ [Get-SPOCrossGeoMovedUsers.ps1](./Get-SPOCrossGeoMovedUsers.ps1)
    
  In a multi-geo tenant returns the SharePoint Online user (or users) that had been moved

+ [Get-SPOCrossGeoUsers.ps1](./Get-SPOCrossGeoUsers.ps1)
    
  Returns the SharePoint Online users in a multi-geo tenant that match the criteria

+ [Get-SPOExternalUser.ps1](./Get-SPOExternalUser.ps1)
    
  Returns external users in the tenant

+ [Get-SPOUser.ps1](./Get-SPOUser.ps1)
    
  Returns the SharePoint Online user or security group accounts that match a given search criteria

+ [Get-SPOUserAndContentMoveState.ps1](./Get-SPOUserAndContentMoveState.ps1)
    
  Allows a SharePoint administrators to check the status of a user or site move across geo locations

+ [Get-SPOUserOneDriveLocation.ps1](./Get-SPOUserOneDriveLocation.ps1)
    
  Return the user principal name, current location, and corresponding OneDrive for Business url, and the site ID

+ [Remove-SPOExternalUser.ps1](./Remove-SPOExternalUser.ps1)
    
  Removes a collection of external users from the tenancy's folder

+ [Remove-SPOUser.ps1](./Remove-SPOUser.ps1)
    
  Removes a user or a security group from a site collection or a group

+ [Remove-SPOUserInfo.ps1](./Remove-SPOUserInfo.ps1)
    
  Removes user from user information list of specific site collection

+ [Remove-SPOUserProfile.ps1](./Remove-SPOUserProfile.ps1)
    
  Remove user profile from the tenant

+ [Revoke-SPOUserSession.ps1](./Revoke-SPOUserSession.ps1)
    
  Provides IT administrators the ability to invalidate a particular users' O365 sessions across all their devices

+ [Set-SPOUser.ps1](./Set-SPOUser.ps1)
    
  Configures properties on an existing user