# Sites

> Note: The use of the scripts requires the PowerShell Module Microsoft.Online.SharePoint.PowerShell.


+ [Add-SPOTenantCdnOrigin.ps1](./Add-SPOTenantCdnOrigin.ps1)
    
  Configures a new origin to public or private content delivery network (CDN)

+ [Approve-SPOTenantServicePrincipalPermissionGrant.ps1](./Approve-SPOTenantServicePrincipalPermissionGrant.ps1)
    
  Approves a permission request for the current tenant's "SharePoint Online Client" service principal  

+ [Approve-SPOTenantServicePrincipalPermissionRequest.ps1](./Approve-SPOTenantServicePrincipalPermissionRequest.ps1)
    
  Approves a permission request for the current tenant's "SharePoint Online Client" service principal 

+ [Deny-SPOTenantServicePrincipalPermissionRequest.ps1](./Deny-SPOTenantServicePrincipalPermissionRequest.ps1)
    
  Denies a permission request for the current tenant's "SharePoint Online Client" service principal 

+ [Get-SPOTenant.ps1](./Get-SPOTenant.ps1)
    
  Returns SharePoint Online organization properties

+ [Get-SPOTenantCdnEnabled.ps1](./Get-SPOTenantCdnEnabled.ps1)
    
  Returns SharePoint Online organization properties

+ [Get-SPOTenantCdnOrigins.ps1](./Get-SPOTenantCdnOrigins.ps1)
    
  Lists all the configured origins under the tenancy or under a given site

+ [Get-SPOTenantCdnPolicies.ps1](./Get-SPOTenantCdnPolicies.ps1)
    
  Get the public or private Policies applied on your SharePoint Online Tenant

+ [Get-SPOTenantLogEntry.ps1](./Get-SPOTenantLogEntry.ps1)
    
  Retrieves SharePoint Online company logs

+ [Get-SPOTenantLogLastAvailableTimeInUtc.ps1](./Get-SPOTenantLogLastAvailableTimeInUtc.ps1)
    
  Returns the most recent time when the SharePoint Online organization logs were collected

+ [Get-SPOTenantServicePrincipalPermissionGrants.ps1](./Get-SPOTenantServicePrincipalPermissionGrants.ps1)
    
  Gets the collection of permission grants for the "SharePoint Online Client" service principal

+ [Get-SPOTenantServicePrincipalPermissionRequests.ps1](./Get-SPOTenantServicePrincipalPermissionRequests.ps1)
    
  Gets the collection of permission requests for the "SharePoint Online Client" service principal 

+ [Get-SPOTenantSyncClientRestriction.ps1](./Get-SPOTenantSyncClientRestriction.ps1)
    
  Returns the current configuration status

+ [Get-SPOTenantTaxonomyReplicationParameters.ps1](./Get-SPOTenantTaxonomyReplicationParameters.ps1)
    
  Get the replication parameters to manage Multi-Geo taxonomy replication

+ [Remove-SPOTenantSyncClientRestriction.ps1](./Remove-SPOTenantSyncClientRestriction.ps1)
    
  Disables the feature for the tenancy

+ [Remove-SPOTenant​Cdn​Origin.ps1](./Remove-SPOTenant​Cdn​Origin.ps1)
    
  Removes a new origin from the Public or Private content delivery network (CDN)

+ [Remove-SPOTenantSyncClientRestriction.ps1](./Remove-SPOTenantSyncClientRestriction.ps1)
    
  Disables the feature for the tenancy

+ [Revoke-SPOTenantServicePrincipalPermission.ps1](./Revoke-SPOTenantServicePrincipalPermission.ps1)

  Revokes a permission that was previously granted to the "SharePoint Online Client" service principal

+ [Set-SPOTenant.ps1](./Set-SPOTenant.ps1)

  Sets properties on the SharePoint Online organization

+ [Set-SPOTenantCdnEnabled.ps1](./Set-SPOTenantCdnEnabled.ps1)

  Enables or disables Public content delivery network (CDN) or Private CDN on the tenant level

+ [Set-SPOTenantCdnPolicy.ps1](./Set-SPOTenantCdnPolicy.ps1)

  Sets the content delivery network (CDN) policies from the tenant level

+ [Set-SPOTenantContentTypeReplicationParameters.ps1](./Set-SPOTenantContentTypeReplicationParameters.ps1)

  Select content types for replication

+ [Set-SPOTenantServicePrincipal.ps1](./Set-SPOTenantServicePrincipal.ps1)

  Enables or disables the current tenant's "SharePoint Online Client" service principal

+ [Set-SPOTenant.ps1](./Set-SPOTenant.ps1)

  Sets properties on the SharePoint Online organization

+ [Set-SPOTenantSyncClientRestriction.ps1](./Set-SPOTenantSyncClientRestriction.ps1)

  Controls tenant-wide options and restrictions specific to syncing files

+ [Set-SPOTenantTaxonomyReplicationParameters.ps1](./Set-SPOTenantTaxonomyReplicationParameters.ps1)

  Select groups for replication