# Sites

> Note: The use of the scripts requires the PowerShell Module Microsoft.Online.SharePoint.PowerShell.


+ [Add-SPOHubSiteAssociation.ps1](./Add-SPOHubSiteAssociation.ps1)

  Associates a site with a hub site  

+ [Add-SPOSiteDesign.ps1](./Add-SPOSiteDesign.ps1)
    
  Creates a new site design available to users when they create a new site from the SharePoint home page

+ [Add-SPOSiteDesignTask.ps1](./Add-SPOSiteDesignTask.ps1)
    
  Apply a published site design to a specified site collection target

+ [Get-SPODeletedSite.ps1](./Get-SPODeletedSite.ps1)
    
  Returns all deleted site collections from the Recycle Bin

+ [Get-SPOHubSite.ps1](./Get-SPOHubSite.ps1)
    
  Lists hub sites or hub site information

+ [Get-SPOSite.ps1](./Get-SPOSite.ps1)
    
  Returns one or more sites 

+ [Get-SPOSiteContentMoveState.ps1](./Get-SPOSiteContentMoveState.ps1)
    
  Allows a SharePoint administrators to check the status of a site or group move

+ [Get-SPOSiteDesign.ps1](./Get-SPOSiteDesign.ps1)
    
  Gets details about site designs that are on the SharePoint tenant

+ [Get-SPOSiteDesignRights.ps1](./Get-SPOSiteDesignRights.ps1)
    
  Displays a list of principals and their rights for usage of the site design. This can be used to determine the scope that your site design has with users on the tenant

+ [Get-SPOSiteDesignRun.ps1](./Get-SPOSiteDesignRun.ps1)
    
  Retrieves a list of site designs applied to a specified site collection

+ [Get-SPOSiteDesignRunStatus.ps1](./Get-SPOSiteDesignRunStatus.ps1)
    
  Retrieves and displays a list of all site script actions executed for a specified site design applied to a site

+ [Get-SPOSiteDesignTask.ps1](./Get-SPOSiteDesignTask.ps1)
    
  Command to remove a scheduled site design script

+ [Get-SPOSiteGroup.ps1](./Get-SPOSiteGroup.ps1)
    
  Gets all the groups on the specified site collection

+ [Grant-SPOHubSiteRights.ps1](./Grant-SPOHubSiteRights.ps1)
    
  Grants rights to users or mail-enabled security groups to associate their site with a hub site

+ [Grant-SPOSiteDesignRights.ps1](./Grant-SPOSiteDesignRights.ps1)
    
  Used to apply permissions to a set of users or a security group, effectively scoping the visibility of the site design in the UX

+ [Invoke-SPOMigrationEncryptUploadSubmit.ps1](./Invoke-SPOMigrationEncryptUploadSubmit.ps1)
    
  Creates a new migration job in the target site collection

+ [Invoke-SPOSiteDesign.ps1](./Invoke-SPOSiteDesign.ps1)
    
  Applies a published site design to a specified site collection target

+ [Invoke-SPOSiteSwap.ps1](./Invoke-SPOSiteSwap.ps1)
    
  Invokes a job to swap the location of a site with another site while archiving the original site

+ [New-SPOSite.ps1](./New-SPOSite.ps1)
    
  Creates a new SharePoint Online site collection for the current company

+ [New-SPOSiteGroup.ps1](./New-SPOSiteGroup.ps1)
    
  Creates a new group in a SharePoint Online site collection

+ [Register-SPOHubSite.ps1](./Register-SPOHubSite.ps1)
    
  Enables the hub site feature on a site to make it a hub site

+ [Remove-SPODeletedSite.ps1](./Remove-SPODeletedSite.ps1)
    
  Removes a SharePoint Online deleted site collection from the Recycle Bin

+ [Remove-SPOHubSiteAssociation.ps1](./Remove-SPOHubSiteAssociation.ps1)

  Removes a site from its associated hub site

+ [Remove-SPOSite.ps1](./Remove-SPOSite.ps1)
    
  Sends a SharePoint Online site collection to the SharePoint Online Recycle Bin

+ [Remove-SPOSiteDesign.ps1](./Remove-SPOSiteDesign.ps1)
    
  Removes a site design

+ [Remove-SPOSiteGroup.ps1](./Remove-SPOSiteGroup.ps1)
    
  Removes a SharePoint Online group from a site collection

+ [Repair-SPOSite.ps1](./Repair-SPOSite.ps1)
    
  Checks and repairs the site collection and its contents

+ [Request-SPOPersonalSite.ps1](./Request-SPOPersonalSite.ps1)
    
  Requests that one or more users be enqueued for a Personal Site to be created

+ [Request-SPOUpgradeEvaluationSite.ps1](./Request-SPOUpgradeEvaluationSite.ps1)
    
  Requests to create a copy of an existing site collection for the purposes of validating the effects of upgrade without affecting the original site

+ [Restore-SPODeletedSite.ps1](./Restore-SPODeletedSite.ps1)
    
  Restores a SharePoint Online deleted site collection from the Recycle Bin

+ [Revoke-SPOHubSiteRights.ps1](./Revoke-SPOHubSiteRights.ps1)
    
  Revokes rights for specified principals to a hub

+ [Revoke-SPOSiteDesignRights.ps1](./Revoke-SPOSiteDesignRights.ps1)
    
  Revokes rights for specified principals from a site design

+ [Set-SPOHubSite.ps1](./Set-SPOHubSite.ps1)
    
  Sets the hub site information such as name, logo, and description

+ [Set-SPOSite.ps1](./Set-SPOSite.ps1)
    
  Sets or updates one or more properties' values for a site collection

+ [Set-SPOSiteDesign.ps1](./Set-SPOSiteDesign.ps1)
    
  Updates a previously uploaded site design

+ [Set-SPOSiteGroup.ps1](./Set-SPOSiteGroup.ps1)
    
  Updates the SharePoint Online owner and permission levels on a group inside a site collection

+ [Set-SPOSiteOffice365Group.ps1](./Set-SPOSiteOffice365Group.ps1)
    
  Connects a top-level SPO site collection to a new Office 365 Group

+ [Test-SPOSite.ps1](./Test-SPOSite.ps1)
    
  Tests a SharePoint Online site collection

+ [Unregister-SPOHubSite.ps1](./Unregister-SPOHubSite.ps1)

  Disables the hub site feature on a site

+ [Upgrade-SPOSite.ps1](./Upgrade-SPOSite.ps1)

  Starts the upgrade process on a site collection