# Action Pack for Microsoft PowerApps/Flow 
Use cases for managing Microsoft PowerApps/Flow

> Note: The use of the scripts requires the PowerShell Module Microsoft.PowerApps.Administration.PowerShell or Microsoft.PowerApps.PowerShell

## [AppsCreators](./AppsCreators)
+ Get/approve/deny flow approval requests
+ Get/enable/remove flow
+ Get flow approval
+ Get flow envirnment
+ Get/remove/set flow owner role
+ Get flow run
+ Get/remove connection
+ Get/remove/set connection role assignment
+ Get/remove connector
+ Get/remove/set connector role assignment
+ Get/remove power app
+ Get/set power app environment
+ Get/remove/set power app role assignment
+ Get power apps notification
+ Get/publish/restore power app version
+ Get tenant graph details
+ Select current environment
+ Set flow/power app as solution aware

## [Apps](./Apps)

+ Get/remove app
+ Get/set/remove role assignment
+ Get app connection reference
+ Set/clear app as featured, hero
+ Set/clear app apis to bypass consent
+ Set app owner

## [Common](./Commn)

+ Add/get/set/remove Dlp policy
+ Add sync user
+ Get tenant graph details
+ Get/set tenant settings
+ Get user details
+ Add Common Data Service database
+ Remove legacy Common Data Service database
+ Set block/unblock tenant from consent plans

## [Connections](./Connections)

+ Get/remove connection
+ Get/set/remove connection role assignments

## [Connectors](./Connectors)

+ Get/remove connector
+ Add/remove connector to/from business data group or policy
+ Get/set/remove connector role assignments

## [Environments](./Environments)

+ Add/get/set/remove environment
+ Get environment locations
+ Get/set/remove role assignments
+ Select current environment
+ Get database currencies, languages

## [Flow](./Flow)

+ Get/enable/disable/remove flow
+ Get/set/remove flow owner role
+ Get/remove flow user details
+ Remove flow approvals

## [Reports](./_REPORTS_)

+ Generate a report with currencies, languages, locations, connections, connectors, environments, flows, apps
+ Generate reports with role assignments of connections, connectors, environments
+ Generate reports with tenant settings, tenant graph details, flow user details

## [Queries](./_QUERY_)

+ Get all currencies, languages, locations
+ Get apps, flows, environments
+ Get principal object ids (AzureAD)

## [Library](./_LIB_)

+ Connect/disconnect Microsoft PowerApps/Flow