# PowerApps scripts for app creators 
Users with a valid PowerApps license can perform the operations in these scripts.
> Note: The use of the scripts requires the PowerShell Module Microsoft.PowerApps.PowerShell

+ [Approve-PAFCFlowApprovalRequest.ps1](./Approve-PAFCFlowApprovalRequest.ps1)

  Approve or reject an approval response

+ [Deny-PAFCFlowApprovalRequest.ps1](./Deny-PAFCFlowApprovalRequest.ps1)

  Approve or reject an approval response

+ [Enable-PAFCFlow.ps1](./Enable-PAFCFlow.ps1)

  Enable/disable the specific flow

+ [Get-PAFCConnection.ps1](./Get-PAFCConnection.ps1)

  Returns connections for the calling user

+ [Get-PAFCConnectionRoleAssignment.ps1](./Get-PAFCConnectionRoleAssignment.ps1)

  Returns all roles assignments for an connection or all connection roles assignments for a user (across all of their connections)

+ [Get-PAFCConnector.ps1](./Get-PAFCConnector.ps1)

  Returns connectors for the calling user

+ [Get-PAFCConnectorRoleAssignment.ps1](./Get-PAFCConnectorRoleAssignment.ps1)

  Returns the connector role assignments for a user or a connector

+ [Get-PAFCFlow.ps1](./Get-PAFCFlow.ps1)

  Returns information about one or more flows

+ [Get-PAFCFlowApproval.ps1](./Get-PAFCFlowApproval.ps1)

  Returns information about approval requests created by the current user

+ [Get-PAFCFlowApprovalRequest.ps1](./Get-PAFCFlowApprovalRequest.ps1)

  Returns information about approval requests assigned to the current user

+ [Get-PAFCFlowEnvironment.ps1](./Get-PAFCFlowEnvironment.ps1)

  Returns information about one or more Flow environments that the user has access to

+ [Get-PAFCFlowOwnerRole.ps1](./Get-PAFCFlowOwnerRole.ps1)

  Gets owner permissions to the flow

+ [Get-PAFCFlowRun.ps1](./Get-PAFCFlowRun.ps1)

  Gets flow run details for a specified flow

+ [Get-PAFCPowerApp.ps1](./Get-PAFCPowerApp.ps1)

  Returns information about one or more apps

+ [Get-PAFCPowerAppEnvironment.ps1](./Get-PAFCPowerAppEnvironment.ps1)

  Returns information about one or more PowerApps environments that the user has access to

+ [Get-PAFCPowerAppRoleAssignment.ps1](./Get-PAFCPowerAppRoleAssignment.ps1)

  Returns the app roles assignments for a user or an app

+ [Get-PAFCPowerAppsNotification.ps1](./Get-PAFCPowerAppsNotification.ps1)

  Returns the PowerApps notifications for the calling users

+ [Get-PAFCPowerAppVersion.ps1](./Get-PAFCPowerAppVersion.ps1)

  Returns all of versions of an app

+ [Get-PAFCTenantGraphDetails.ps1](./Get-PAFCTenantGraphDetails.ps1)

  Returns tenant graph details

+ [Publish-PAFCPowerAppVersion.ps1](./Publish-PAFCPowerAppVersion.ps1)

  Publishes the current 'draft' version of the app to be the 'live' version of the app

+ [Remove-PAFCConnection.ps1](./Remove-PAFCConnection.ps1)

  Deletes the connection

+ [Remove-PAFCConnectionRoleAssignment.ps1](./Remove-PAFCConnectionRoleAssignment.ps1)

  Deletes a connection role assignment record

+ [Remove-PAFCConnector.ps1](./Remove-PAFCConnector.ps1)

  Deletes the custom connector

+ [Remove-PAFCConnectorRoleAssignment.ps1](./Remove-PAFCConnectorRoleAssignment.ps1)

  Deletes a connector role assignment record

+ [Remove-PAFCFlow.ps1](./Remove-PAFCFlow.ps1)

  Removes a flow

+ [Remove-PAFCFlowOwnerRole.ps1](./Remove-PAFCFlowOwnerRole.ps1)

  Removes owner permissions to the flow

+ [Remove-PAFCPowerApp.ps1](./Remove-PAFCPowerApp.ps1)

  Deletes the app

+ [Remove-PAFCPowerAppRoleAssignment.ps1](./Remove-PAFCPowerAppRoleAssignment.ps1)

  Deletes an app roles assignment

+ [Restore-PAFCPowerAppVersion.ps1](./Restore-PAFCPowerAppVersion.ps1)

  Restores the current 'draft' version of the app to be the specified App Version

+ [Select-PAFCCurrentEnvironment.ps1](./Select-PAFCCurrentEnvironment.ps1)

  Sets the current environment for listing powerapps, flows, and other environment resources

+ [Set-PAFCConnectionRoleAssignment.ps1](./Set-PAFCConnectionRoleAssignment.ps1)

  Sets permissions to the connection

+ [Set-PAFCConnectorRoleAssignment.ps1](./Set-PAFCConnectorRoleAssignment.ps1)

  Sets permissions to the connection

+ [Set-PAFCFlowAsSolutionAware.ps1](./Set-PAFCFlowAsSolutionAware.ps1)

  Sets the flow as solution aware

+ [Set-PAFCFlowOwnerRole.ps1](./Set-PAFCFlowOwnerRole.ps1)

  Sets owner permissions to the flow

+ [Set-PAFCPowerApp.ps1](./Set-PAFCPowerApp.ps1)

  Sets the app properties

+ [Set-PAFCPowerAppAsSolutionAware.ps1](./Set-PAFCPowerAppAsSolutionAware.ps1)

  Sets the powerapp as solution aware

+ [Set-PAFCPowerAppRoleAssignment.ps1](./Set-PAFCPowerAppRoleAssignment.ps1)

  Sets permissions to the app