# Action Pack for Microsoft Teams 
Use cases for managing Microsoft Teams

> Note: The use of the scripts requires the PowerShell Module microsoftteams

## [Apps](./Apps)

+ Create/set/get/remove Team app
+ Add/get/update/remove a Teams App in Microsoft Teams

## [Channels](./Channels)

+ Create/set/get/remove Team channel
+ Add/get/remove users to a Team channel
+ Send a message to a Team Channel
+ Add/remove channels to all teams

## [Common](./Common)

+ Clear Teams cache

## [Members](./Members)

+ Add/get/remove users from a team
+ Add/remove users to all teams
+ Get Multi Geo Region
+ Get License report

## [Policies](./Policies)

+ Get policy package
+ Grant/get user policy package
+ Grant group policy package assignment
+ New/get/update/remove group policy assignment
+ New/update/remove custom policy package 
+ Get user policy assignment, user policy recommendation
+ New/get batch policy assignment operation

## [Teams](./Teams)

+ Create/set/get/remove Team
+ Set team archived state
+ Check the owner's number
+ Set the picture of a team 
+ Set/remove Teams target hierarchy
+ Get Team targeting hierarchy status

## [Templates](./Templates)

+ Create/update/get/remove Team template
+ Get Team template list

## [Reports](./_Report_)

+ Generate report with teams, team channels, team apps, team user, team channel users, team statistic
+ Generate report with user policy assignments, user policy packages, user policy package recommendation
+ Generate report with group policy assignments
+ Generate report with policy packages
+ Report with all team members, with role, from all teams
+ Report with all team channels, from all teams

## [Queries](./_QUERY_)

+ Search group ids
+ Search template OdataIds

## [Library](./_LIB_)

+ Connect/disconnect Microsoft Teams 
+ Publish a message in a Microsoft Teams channel
+ Open a Skype for Business online session