# Policies

> Note: The use of the scripts requires the PowerShell microsoftteams. Version 1.0.5 or greater

+ [Get-MSTBatchPolicyAssignmentOperation.ps1](./Get-MSTBatchPolicyAssignmentOperation.ps1)

  Retrieve the status of batch policy assignment operations

+ [Get-MSTGroupPolicyAssignment.ps1](./Get-MSTGroupPolicyAssignment.ps1)

  Returns group policy assignments

+ [Get-MST​Policy​Package.ps1](./Get-MSTPolicy​Package.ps1)

  Retrieving all the policy packages available on a tenant

+ [Get-MSTUserPolicyAssignment.ps1](./Get-MSTUserPolicyAssignment.ps1)

  Return the policy assignments for a user

+ [Get-MSTUserPolicyPackage.ps1](./Get-MSTUserPolicyPackage.ps1)

  Retrieving the policy package that's assigned to a user

+ [Get-MST​UserPolicyPackageRecommendation.ps1](./Get-MSTUserPolicyPackageRecommendation.ps1)

  Retrieving recommendations for which policy packages are best suited for a given user

+ [Grant-MSTGroupPolicyPackageAssignment.ps1](./Grant-MSTGroupPolicyPackageAssignment.ps1)

  Assigns a policy package to a group in a tenant

+ [Grant-MSTUser​Policy​Package.ps1](./Grant-MSTUserPolicy​Package.ps1)

  Applying a policy package to users in a tenant

+ [New-MSTBatchPolicyAssignmentOperation.ps1](./New-MSTBatchPolicyAssignmentOperation.ps1)

  Submits an operation that applies a policy package to a batch of users in a tenant

+ [New-MSTCustom​Policy​Package.ps1](./New-MSTCustomPolicyPackage.ps1)

  Submits an operation that creates a custom policy package with custom package name, description and a list of policies

+ [New-MSTGroupPolicyAssignment.ps1](./New-MSTGroupPolicyAssignment.ps1)

  Assign a policy to a security group or distribution list

+ [Remove-MSTCustom​Policy​Package.ps1](./Remove-MSTCustomPolicyPackage.ps1)

  Submits an operation that deletes a custom policy package with the given package name

+ [Remove-MSTGroupPolicyAssignment.ps1](./Remove-MSTGroupPolicyAssignment.ps1)

  Remove a group policy assignment

+ [Set-MSTGroupPolicyAssignment.ps1](./Set-MSTGroupPolicyAssignment.ps1)

  Update a group policy assignment

+ [Update-MSTCustom​Policy​Package.ps1](./Update-MSTCustomPolicyPackage.ps1)

  Submits an operation that updates a custom policy package with new package settings