# Virtual machines

> Note: The use of the scripts requires the PowerShell Module Hyper-V.

+ [Add-MSHVVirtualMachineDvdDrive.ps1](./Add-MSHVVirtualMachineDvdDrive.ps1)

  Adds a DVD drive to a virtual machine

+ [Export-MSHVVirtualMachine.ps1](./Export-MSHVVirtualMachine.ps1)

  Exports a virtual machine to disk

+ [Get-MSHVVirtualMachineBios.ps1](./Get-MSHVVirtualMachineBios.ps1)

  Gets the BIOS configuration of a virtual machine. This is only supported on Generation 1 virtual machines

+ [Get-MSHVVirtualMachineComPorts.ps1](./Get-MSHVVirtualMachineComPorts.ps1)

  Gets the COM ports of a virtual machine

+ [Get-MSHVVirtualMachineDvdDrive.ps1](./Get-MSHVVirtualMachineDvdDrive.ps1)

  Gets the DVD drive attached to the virtual machine

+ [Get-MSHVVirtualMachineDvdDrives.ps1](./Get-MSHVVirtualMachineDvdDrives.ps1)

  Gets the DVD drives attached to the virtual machine
    
+ [Get-MSHVVirtualMachineFirmware.ps1](./Get-MSHVVirtualMachineFirmware.ps1)

  Gets the firmware configuration of a virtual machine. This is only supported on Generation 2 virtual machines

+ [Get-MSHVVirtualMachineFloppyDiskDrive.ps1](./Get-MSHVVirtualMachineFloppyDiskDrive.ps1)

  Gets the floppy disk drive of a virtual machine 

+ [Get-MSHVVirtualMachineProperties.ps1](./Get-MSHVVirtualMachineProperties.ps1)

  Gets the virtual machine properties from the Hyper-V host

+ [Get-MSHVVirtualMachines.ps1](./Get-MSHVVirtualMachines.ps1)

  Gets the properties of all virtual machines from the Hyper-V host

+ [Get-MSHVVirtualMachineVideo.ps1](./Get-MSHVVirtualMachineVideo.ps1)

  Gets video settings for a virtual machine

+ [Import-MSHVVirtualMachine.ps1](./Import-MSHVVirtualMachine.ps1)

  Imports a virtual machine from a file

+ [Manage-MSHVVirtualMachine.ps1](./Manage-MSHVVirtualMachine.ps1)

  Invokes a command for the virtual machine from the Hyper-V host.<br>
  The acceptable commands are: Start, Stop, Suspend, Resume, Restart, Save and Turn off

+ [Measure-MSHVVirtualMachine.ps1](./Measure-MSHVVirtualMachine.ps1)

  Reports resource utilization data for the virtual machine

+ [New-MSHVVirtualMachine.ps1](./New-MSHVVirtualMachine.ps1)

  Creates a new virtual machine

+ [Remove-MSHVVirtualMachine.ps1](./Remove-MSHVVirtualMachine.ps1)

  Deletes a virtual machine

+ [Remove-MSHVVirtualMachineDvdDrive.ps1](./Remove-MSHVVirtualMachineDvdDrive.ps1)

  Deletes a DVD drive from a virtual machine

+ [Set-MSHVAutomaticCriticalError.ps1](./Set-MSHVAutomaticCriticalError.ps1)

  Sets the action to take when the virtual machine encounters a critical error

+ [Set-MSHVAutomaticStart.ps1](./Set-MSHVAutomaticStart.ps1)

  Sets the action on the virtual machine is to take upon start

+ [Set-MSHVAutomaticStop.ps1](./Set-MSHVAutomaticStop.ps1)

  Sets the action on the virtual machine is to take when the virtual machine host shuts down 

+ [Set-MSHVIntegrationServices.ps1](./Set-MSHVIntegrationServices.ps1)

  Sets the integration services on a virtual machine

+ [Set-MSHVVirtualMachineBios.ps1](./Set-MSHVVirtualMachineBios.ps1)

  Configures the BIOS of a Generation 1 virtual machine

+ [Set-MSHVVirtualMachineComPort.ps1](./Set-MSHVVirtualMachineComPort.ps1)

  Configures the COM port of a virtual machine  

+ [Set-MSHVVirtualMachineCPUs.ps1](./Set-MSHVVirtualMachineCPUs.ps1)

  Sets the number of virtual processors for the virtual machine

+ [Set-MSHVVirtualMachineDvdDrive.ps1](./Set-MSHVVirtualMachineDvdDrive.ps1)

  Configures a virtual DVD drive

+ [Set-MSHVVirtualMachineFirmware.ps1](./Set-MSHVVirtualMachineFirmware.ps1)

  Sets the firmware configuration of a virtual machine. This is only supported on Generation 2 virtual machines

+ [Set-MSHVVirtualMachineFloppyDiskDrive.ps1](./Set-MSHVVirtualMachineFloppyDiskDrive.ps1)

  Configures a virtual floppy disk drive

+ [Set-MSHVVirtualMachineMemory.ps1](./Set-MSHVVirtualMachineMemory.ps1)

  Configures the memory of a virtual machine

+ [Set-MSHVVirtualMachineMetering.ps1](./Set-MSHVVirtualMachineMetering.ps1)

  Enables, reset or disables collection of resource utilization data for a virtual machine 

+ [Set-MSHVVirtualMachineSwitch.ps1](./Set-MSHVVirtualMachineSwitch.ps1)

  Sets a virtual switch to the virtual machine

+ [Set-MSHVVirtualMachineVHDSize.ps1](./Set-MSHVVirtualMachineVHDSize.ps1)

  Sets the size of a virtual hard disk for the virtual machine

+ [Set-MSHVVirtualMachineVideo.ps1](./Set-MSHVVirtualMachineVideo.ps1)

  Configures video settings for virtual machine