# Sites

> Note: The use of the scripts requires the Citrix PowerShell SnapIns.

+ [Add-CTXController.ps1](./Add-CTXController.ps1)

  Adds a Delivery Controller to an existing Site

+ [Export-CTXDatabaseSchema.ps1](./Export-CTXDatabaseSchema.ps1)

  Gets the SQL scripts used to create and manage the Database

+ [Get-CTXConfigRegisteredServiceInstance.ps1](./Get-CTXConfigRegisteredServiceInstance.ps1)

  Gets the service instances that are registered in the directory

+ [Get-CTXController.ps1](./Get-CTXController.ps1)

  Gets Controllers running broker services in the site

+ [Get-CTXControllerMetadata.ps1](./Get-CTXControllerMetadata.ps1)

  Gets the metadata from the controller

+ [Get-CTXRegisteredServiceMetadata.ps1](./Get-CTXRegisteredServiceMetadata.ps1)

  Gets the metadata from the service instance

+ [Get-CTXSite.ps1](./Get-CTXSite.ps1)

  Gets the current XenDesktop broker site

+ [Get-CTXSiteMetaData.ps1](./Get-CTXSiteMetaData.ps1)

  Gets the metadata from the site

+ [Get-CTXZones.ps1](./Get-CTXZones.ps1)

  Gets zones configured for this site

+ [Get-CTXZoneMetaData.ps1](./Get-CTXZoneMetaData.ps1)

  Gets the metadata from the zone

+ [Get-CTXZoneUsers.ps1](./Get-CTXZoneUsers.ps1)

  Gets user/group accounts with zone preferences configured for this site

+ [New-CTXSite.ps1](./New-CTXSite.ps1)

  Creates a XenDesktop broker site

+ [New-CTXSiteDatabase.ps1](./New-CTXSiteDatabase.ps1)

  Creates the specified Database or all Databases

+ [New-CTXZone.ps1](./New-CTXZone.ps1)

  Creates a new zone in the site

+ [New-CTXZoneUser.ps1](./New-CTXZoneUser.ps1)

  Creates a zone preference for a user/group account in this site

+ [Remove-CTXController.ps1](./Remove-CTXController.ps1)

  Removes a Delivery Controller from an existing Site

+ [Remove-CTXControllerMetaData.ps1](./Remove-CTXControllerMetaData.ps1)

  Removes metadata from the controller

+ [Remove-CTXRegisteredServiceMetaData.ps1](./Remove-CTXRegisteredServiceMetaData.ps1)

  Removes metadata from the given service instance

+ [Remove-CTXSiteMetaData.ps1](./Remove-CTXSiteMetaData.ps1)

  Removes metadata from the site

+ [Remove-CTXZone.ps1](./Remove-CTXZone.ps1)

  Removes a zone from the site

+ [Remove-CTXZoneMetaData.ps1](./Remove-CTXZoneMetaData.ps1)

  Removes metadata from the zone

+ [Remove-CTXZoneUser.ps1](./Remove-CTXZoneUser.ps1)

  Removes any zone preference associated with a user/group account in this site

+ [Rename-CTXZone.ps1](./Rename-CTXZone.ps1)

  Renames the zone

+ [Set-CTXConfigRegisteredServiceInstance.ps1](./Set-CTXConfigRegisteredServiceInstance.ps1)

  Updates a service instance

+ [Set-CTXControllerMetaData.ps1](./Set-CTXControllerMetaData.ps1)

  Creates or updates metadata for the controller

+ [Set-CTXLicenseServer.ps1](./Set-CTXLicenseServer.ps1)

  Changes one or more of the licensing attributes of a Site

+ [Set-CTXSite.ps1](./Set-CTXSite.ps1)

  Changes the overall settings of the current XenDesktop broker site

+ [Set-CTXSiteMetaData.ps1](./Set-CTXSiteMetaData.ps1)

  Creates or updates metadata for the site

+ [Set-CTXZone.ps1](./Set-CTXZone.ps1)

  Set the properties of the zone

+ [Set-CTXZoneMetaData.ps1](./Set-CTXZoneMetaData.ps1)

  Creates or updates metadata for the zone

+ [Set-CTXZoneUser.ps1](./Set-CTXZoneUser.ps1)

  Changes the zone preference associated with a user/group account in this site

+ [Unregister-CTXConfigRegisteredServiceInstance.ps1](./Unregister-CTXConfigRegisteredServiceInstance.ps1)

  Removes a service instance from the Configuration Service registry