﻿#Requires -Version 5.0

<#
    .SYNOPSIS
        Changes the zone preference associated with a user/group account in this site
    
    .DESCRIPTION  

    .NOTES
        This PowerShell script was developed and optimized for ScriptRunner. The use of the scripts requires ScriptRunner. 
        The customer or user is authorized to copy the script from the repository and use them in ScriptRunner. 
        The terms of use for ScriptRunner do not apply to this script. In particular, ScriptRunner Software GmbH assumes no liability for the function, 
        the use and the consequences of the use of this freely available script.
        PowerShell is a product of Microsoft Corporation. ScriptRunner is a product of ScriptRunner Software GmbH.
        © ScriptRunner Software GmbH

    .COMPONENT
        Requires the library script CitrixLibrary.ps1
        Requires PSSnapIn Citrix*

    .LINK
        https://github.com/scriptrunner/ActionPacks/blob/master/Citrix/Sites
        
    .Parameter SiteServer
        [sr-en] Specifies the address of a XenDesktop controller. 
        This can be provided as a host name or an IP address
        [sr-de] Name oder IP Adresse des XenDesktop Controllers

    .Parameter Name
        [sr-en] Name of the user/group account whose home zone preference is to be changed (domain\account)
        [sr-de] Name des Benutzers oder der Gruppe dessen Zonenzuweisung geändert wird (domain\account)

    .Parameter HomeZoneUid
        [sr-en] Home zone preference to be associated with the user/group account
        [sr-de] Uid der Zone, der der Benutzer oder die Gruppe zugewiesen werden soll
#>

param( 
    [Parameter(Mandatory = $true)]
    [string]$Name,
    [Parameter(Mandatory = $true)]
    [string]$HomeZoneUid,
    [string]$SiteServer    
)                                                            

$LogID = $null
[bool]$success = $false
try{ 
    [string[]]$Properties = @('Name','FullName','HomeZoneName','SID')
    StartCitrixSessionAdv -ServerName ([ref]$SiteServer)
    StartLogging -ServerAddress $SiteServer -LogText "Change Zone for Account $($Name)" -LoggingID ([ref]$LogID)
                      
    [hashtable]$cmdArgs = @{'ErrorAction' = 'Stop'
                            'AdminAddress' = $SiteServer
                            'PassThru' = $null
                            'Name' = $Name
                            'LoggingId' = $LogID
                            'HomeZoneUid' = $HomeZoneUid
                            }    
    
    $null = Set-BrokerUserZonePreference @cmdArgs 
    $ret = Get-BrokerUserZonePreference -HomeZoneUid $HomeZoneUid -AdminAddress $SiteServer -ErrorAction Stop | Select-Object $Properties
    $success = $true
    if($SRXEnv) {
        $SRXEnv.ResultMessage = $ret
    }
    else{
        Write-Output $ret
    }
}
catch{
    throw 
}
finally{
    StopLogging -LoggingID $LogID -ServerAddress $SiteServer -IsSuccessful $success
    CloseCitrixSession
}