# Policies

> Note: The use of the scripts requires the Citrix PowerShell SnapIns.

+ [Get-CTXAccessPolicyRule.ps1](./Get-CTXAccessPolicyRule.ps1)

  Gets access policy rules 

+ [Get-CTXAccessPolicyRuleMetadata.ps1](./Get-CTXAccessPolicyRuleMetadata.ps1)

  Gets access policy rule Metadata

+ [Get-CTXAppAssignmentPolicyRule.ps1](./Get-CTXAppAssignmentPolicyRule.ps1)

  Gets application rules from the site's assignment policy

+ [Get-CTXAppEntitlementPolicyRule.ps1](./Get-CTXAppEntitlementPolicyRule.ps1)

  Gets application rules from the site's entitlement policy

+ [Get-CTXAssignmentPolicyRule.ps1](./Get-CTXAssignmentPolicyRule.ps1)

  Gets assignment policy rules 

+ [Get-CTXAssignmentPolicyRuleMetadata.ps1](./Get-CTXAssignmentPolicyRuleMetadata.ps1)

  Gets assignment policy rule Metadata

+ [Get-CTXEntitlementPolicyRule.ps1](./Get-CTXEntitlementPolicyRule.ps1)

  Gets desktop rules from the site's entitlement policy

+ [Get-CTXEntitlementPolicyRuleMetadata.ps1](./Get-CTXEntitlementPolicyRuleMetadata.ps1)

  Gets entitlement policy rule Metadata

+ [New-CTXAccessPolicyRule.ps1](./New-CTXAccessPolicyRule.ps1)

  Creates an access policy rule 

+ [New-CTXAppAssignmentPolicyRule.ps1](./New-CTXAppAssignmentPolicyRule.ps1)

  Creates a new application rule in the site's assignment policy

+ [New-CTXAppEntitlementPolicyRule.ps1](./New-CTXAppEntitlementPolicyRule.ps1)

  Creates a new application rule in the site's entitlement policy

+ [New-CTXAssignmentPolicyRule.ps1](./New-CTXAssignmentPolicyRule.ps1)

  Creates an assignment policy rule

+ [New-CTXEntitlementPolicyRule.ps1](./New-CTXEntitlementPolicyRule.ps1)

  Creates a new desktop rule in the site's entitlement policy

+ [Remove-CTXAccessPolicyRule.ps1](./Remove-CTXAccessPolicyRule.ps1)

  Removes an access policy rule 

+ [Remove-CTXAccessPolicyRuleMetadata.ps1](./Remove-CTXAccessPolicyRuleMetadata.ps1)

  Removes metadata from the given access policy rule

+ [Remove-CTXAppAssignmentPolicyRule.ps1](./Remove-CTXAppAssignmentPolicyRule.ps1)

  Removes an application rule in the site's assignment policy

+ [Remove-CTXAppEntitlementPolicyRule.ps1](./Remove-CTXAppEntitlementPolicyRule.ps1)

  Removes an application rule from the site's entitlement policy

+ [Remove-CTXAssignmentPolicyRule.ps1](./Remove-CTXAssignmentPolicyRule.ps1)

  Removes a desktop rule from the site's assignment policy

+ [Remove-CTXAssignmentPolicyRuleMetadata.ps1](./Remove-CTXAssignmentPolicyRuleMetadata.ps1)

  Removes metadata from the given assignment policy rule

+ [Remove-CTXEntitlementPolicyRule.ps1](./Remove-CTXEntitlementPolicyRule.ps1)

  Removes a desktop rule from the site's entitlement policy

+ [Remove-CTXEntitlementPolicyRuleMetadata.ps1](./Remove-CTXEntitlementPolicyRuleMetadata.ps1)

  Removes metadata from the given entitlement policy rule

+ [Rename-CTXAccessPolicyRule.ps1](./Rename-CTXAccessPolicyRule.ps1)

  Renames an access policy rule 

+ [Rename-CTXAppAssignmentPolicyRule.ps1](./Rename-CTXAppAssignmentPolicyRule.ps1)

  Renames an application rule in the site's assignment policy

+ [Rename-CTXAppEntitlementPolicyRule.ps1](./Rename-CTXAppEntitlementPolicyRule.ps1)

  Renames an application rule in the site's entitlement policy

+ [Rename-CTXAssignmentPolicyRule.ps1](./Rename-CTXAssignmentPolicyRule.ps1)

  Renames a desktop rule from the site's assignment policy

+ [Rename-CTXEntitlementPolicyRule.ps1](./Rename-CTXEntitlementPolicyRule.ps1)

  Renames a desktop rule from the site's entitlement policy

+ [Set-CTXAccessPolicyRule.ps1](./Set-CTXAccessPolicyRule.ps1)

  Changes an access policy rule  

+ [Set-CTXAccessPolicyRuleMetadata.ps1](./Set-CTXAccessPolicyRuleMetadata.ps1)

  Creates or updates metadata for access policy rule

+ [Set-CTXAppAssignmentPolicyRule.ps1](./Set-CTXAppAssignmentPolicyRule.ps1)

  Updates a application rule in the site's assignment policy

+ [Set-CTXAppEntitlementPolicyRule.ps1](./Set-CTXAppEntitlementPolicyRule.ps1)

  Updates an existing application rule in the site's entitlement policy

+ [Set-CTXAssignmentPolicyRule.ps1](./Set-CTXAssignmentPolicyRule.ps1)

  Updates an assignment policy rule 

+ [Set-CTXAssignmentPolicyRuleMetadata.ps1](./Set-CTXAssignmentPolicyRuleMetadata.ps1)

  Creates or updates metadata for assignment policy rule

+ [Set-CTXEntitlementPolicyRule.ps1](./Set-CTXEntitlementPolicyRule.ps1)

  Changes a desktop rule from the site's entitlement policy

+ [Set-CTXEntitlementPolicyRuleMetadata.ps1](./Set-CTXEntitlementPolicyRuleMetadata.ps1)

  Creates or updates metadata for entitlement policy rule

+ [Test-CTXAccessPolicyRuleNameAvailable.ps1](./Test-CTXAccessPolicyRuleNameAvailable.ps1)

  Determine whether the proposed AccessPolicyRule Name is available for use

+ [Test-CTXAppAssignmentPolicyRuleNameAvailable.ps1](./Test-CTXAppAssignmentPolicyRuleNameAvailable.ps1)

  Determine whether the proposed AppAssignmentPolicyRule Name is available for use

+ [Test-CTXAppEntitlementPolicyRuleNameAvailable.ps1](./Test-CTXAppEntitlementPolicyRuleNameAvailable.ps1)

  Determine whether the proposed AppEntitlementPolicyRule Name is available for use

+ [Test-CTXAssignmentPolicyRuleNameAvailable.ps1](./Test-CTXAssignmentPolicyRuleNameAvailable.ps1)

  Determine whether the proposed AssignmentPolicyRule Name is available for use

+ [Test-CTXEntitlementPolicyRuleNameAvailable.ps1](./Test-CTXEntitlementPolicyRuleNameAvailable.ps1)

  Determine whether the proposed EntitlementPolicyRule Name is available for use