# Logging

> Note: The use of the scripts requires the Citrix PowerShell SnapIns.

+ [Export-CTXLogReportCsv.ps1](./Export-CTXLogReportCsv.ps1)

  Exports Configuration Logging data into a CSV file

+ [Export-CTXLogReportHtml.ps1](./Export-CTXLogReportHtml.ps1)

  Exports Configuration Logging data into a HTML report

+ [Get-CTXLogDataStore.ps1](./Get-CTXLogDataStore.ps1)

  Gets details for each of the ConfigurationLogging data stores

+ [Get-CTXLogDBConnection.ps1](./Get-CTXLogDBConnection.ps1)

  Gets the database string for the specified data store used by the ConfigurationLogging Service

+ [Get-CTXLogHighLevelOperations.ps1](./Get-CTXLogHighLevelOperations.ps1)

  Gets high level operations

+ [Get-CTXLogLowLevelOperations.ps1](./Get-CTXLogLowLevelOperations.ps1)

  Gets low level operations

+ [Get-CTXLogInstalledDBVersion.ps1](./Get-CTXLogInstalledDBVersion.ps1)

  Gets a list of all available database schema versions for the ConfigurationLogging Service

+ [Get-CTXLogService.ps1](./Get-CTXLogService.ps1)

  Gets the service record entries for the ConfigurationLogging Service

+ [Get-CTXLogServiceInstance.ps1](./Get-CTXLogServiceInstance.ps1)

  Gets the service record entries for the ConfigurationLogging Service

+ [Get-CTXLogServiceStatus.ps1](./Get-CTXLogServiceStatus.ps1)

  Gets the current status of the ConfigurationLogging Service on the controller

+ [Get-CTXLogSite.ps1](./Get-CTXLogSite.ps1)

  Gets global configuration logging settings

+ [Get-CTXLogServiceMetadata.ps1](./Get-CTXLogServiceMetadata.ps1)

  Returns the metadata from the given Service

+ [Get-CTXLogSiteMetadata.ps1](./Get-CTXLogSiteMetadata.ps1)

  Returns the metadata from the given Site

+ [Get-CTXLogSummary.ps1](./Get-CTXLogSummary.ps1)

  Gets operations logged within time intervals inside a date range

+ [Remove-CTXLogOperation.ps1](./Remove-CTXLogOperation.ps1)

  Deletes configuration logs

+ [Remove-CTXLogServiceMetadata.ps1](./Remove-CTXLogServiceMetadata.ps1)

  Removes metadata from the given Service

+ [Remove-CTXLogSiteMetadata.ps1](./Remove-CTXLogSiteMetadata.ps1)

  Removes metadata from the given Site

+ [Reset-CTXLogDataStore.ps1](./Reset-CTXLogDataStore.ps1)

  Refreshes the database string currently being used by the Log service

+ [Reset-CTXLogEnabledFeatureList.ps1](./Reset-CTXLogEnabledFeatureList.ps1)

  Requests a refresh of the list of enabled features

+ [Reset-CTXLogServiceGroupMembership.ps1](./Reset-CTXLogServiceGroupMembership.ps1)

  Reloads the access permissions and configuration service locations for the ConfigurationLogging Service

+ [Set-CTXLogDBConnection.ps1](./Set-CTXLogDBConnection.ps1)

  Configures a database connection for the ConfigurationLogging Service

+ [Set-CTXLogSite.ps1](./Set-CTXLogSite.ps1)

  Sets global configuration logging settings

+ [Set-CTXLogServiceMetadata.ps1](./Set-CTXLogServiceMetadata.ps1)

  Adds or updates metadata on the given Service

+ [Set-CTXLogSiteMetadata.ps1](./Set-CTXLogSiteMetadata.ps1)

  Adds or updates metadata on the given Site

+ [Test-CTXLogDBConnection.ps1](./Test-CTXLogDBConnection.ps1)

  Tests whether a database is suitable for use by the Citrix ConfigurationLogging Service