# Licenses

> Note: The use of the scripts requires the Citrix PowerShell SnapIns.

+ [Get-CTXLicenseAdministrators.ps1](./Get-CTXLicenseAdministrators.ps1)

  Gets a list of administrator accounts configured to access the License Server

+ [Get-CTXLicenseCeipOption.ps1](./Get-CTXLicenseCeipOption.ps1)

  Returns current CEIP option set on the License Server

+ [Get-CTXLicenseCertificate.ps1](./Get-CTXLicenseCertificate.ps1)

  Gets the self-signed X509 certificate from the specified License Server

+ [Get-CTXLicenseConfigUsageSamples.ps1](./Get-CTXLicenseConfigUsageSamples.ps1)

  Returns current configuration for sample collection on license usages

+ [Get-CTXLicenseInventory.ps1](./Get-CTXLicenseInventory.ps1)

  Gets License Inventory Data from the License Server

+ [Get-CTXLicenseLocalizedNames.ps1](./Get-CTXLicenseLocalizedNames.ps1)

  Gets the friendly name of the products and license types saved on License Server

+ [Get-CTXLicenseSARenewalOptions.ps1](./Get-CTXLicenseSARenewalOptions.ps1)

  Returns current Customer Success Services renewal license check option set on the License Server

+ [Get-CTXLicenseRenewals.ps1](./Get-CTXLicenseRenewals.ps1)

  Enumerates the list of Customer Success Services renewal licenses available from citrix.com for the installed licenses

+ [Get-CTXLicenseServerInfo.ps1](./Get-CTXLicenseServerInfo.ps1)

  Gets the self-signed X509 certificate from the specified License Server

+ [Get-CTXLicenseUsageDetails.ps1](./Get-CTXLicenseUsageDetails.ps1)

  Gets the license usage details for the requested Product Edition Model

+ [Import-CTXLicenseFile.ps1](./Import-CTXLicenseFile.ps1)

  Import License File to the License Server

+ [New-CTXLicenseAdministrator.ps1](./New-CTXLicenseAdministrator.ps1)

  Adds an Active Directory account or group to the list of administrators on the License Server

+ [Remove-CTXLicenseAdministrator.ps1](./Remove-CTXLicenseAdministrator.ps1)

  Removes an Active Directory account or group from the list of Administrators on the License Server

+ [Set-CTXLicenseAdministrator.ps1](./Set-CTXLicenseAdministrator.ps1)

  Sets the permission level of the specified License Server administrator

+ [Set-CTXLicenseCeipOption.ps1](./Set-CTXLicenseCeipOption.ps1)

  Sets the CEIP option on the License Server

+ [Set-CTXLicenseConfigUsageSamples.ps1](./Set-CTXLicenseConfigUsageSamples.ps1)

  Sets the configuration to collect samples of license usage

+ [Set-CTXLicenseSARenewalOptions.ps1](./Set-CTXLicenseSARenewalOptions.ps1)

  Sets the Customer Success Services renewal license check option on the License Server

+ [Test-CTXLicenseServer.ps1](./Test-CTXLicenseServer.ps1)

  Tests whether or not a license server can be used by the broker