# Applications

> Note: The use of the scripts requires the Citrix PowerShell SnapIns.

+ [Add-CTXApplication.ps1](./Add-CTXApplication.ps1)

  Adds applications to a desktop group or application group

+ [Add-CTXApplicationGroup.ps1](./Add-CTXApplicationGroup.ps1)

  Add application group to a desktop group

+ [Add-CTXApplicationToGroup.ps1](./Add-CTXApplicationToGroup.ps1)

  Adds application to a desktop group or application group 

+ [Add-CTXDesktopGroup.ps1](./Add-CTXDesktopGroup.ps1)

  Associate Remote PC desktop groups with the specified Remote PC catalog

+ [Get-CTXApplications.ps1](./Get-CTXApplications.ps1)

  Get the applications published on this site

+ [Get-CTXApplicationFolderMetadata.ps1](./Get-CTXApplicationFolderMetadata.ps1)

  Gets metadata from the admin folder

+ [Get-CTXApplicationFolders.ps1](./Get-CTXApplicationFolders.ps1)

  Get the admin folders in this site

+ [Get-CTXApplicationGroupMetadata.ps1](./Get-CTXApplicationGroupMetadata.ps1)

  Gets metadata from the application group

+ [Get-CTXApplicationGroups.ps1](./Get-CTXApplicationGroups.ps1)

  Gets details of configured application groups

+ [Get-CTXCatalogMetadata.ps1](./Get-CTXCatalogMetadata.ps1)

  Gets Catalog Metadata from the Catalog objects

+ [Get-CTXCatalogs.ps1](./Get-CTXCatalogs.ps1)

  Gets catalogs configured for this site

+ [Get-CTXDesktopGroupMetadata.ps1](./Get-CTXDesktopGroupMetadata.ps1)

  Gets metadata from the desktop group

+ [Get-CTXDesktopGroups.ps1](./Get-CTXDesktopGroups.ps1)

  Gets broker desktop groups

+ [Get-CTXRebootCycle.ps1](./Get-CTXRebootCycle.ps1)

  Gets one or more reboot cycles

+ [Get-CTXRebootSchedule.ps1](./Get-CTXRebootSchedule.ps1)

  Gets one or more reboot schedules

+ [Get-CTXRebootScheduleMetadata.ps1](./Get-CTXRebootScheduleMetadata.ps1)

  Gets metadata from the reboot schedule

+ [Move-CTXApplication.ps1](./Move-CTXApplication.ps1)

  Move a published application from one admin folder to another

+ [Move-CTXApplicationFolder.ps1](./Move-CTXApplicationFolder.ps1)

  Moves a folder to another place in the hierarchy, optionally renaming it

+ [New-CTXApplication.ps1](./New-CTXApplication.ps1)

  Creates a new published application

+ [New-CTXApplicationFolder.ps1](./New-CTXApplicationFolder.ps1)

  Creates a new admin folder

+ [New-CTXApplicationGroup.ps1](./New-CTXApplicationGroup.ps1)

  Create a new application group to which applications can be added

+ [New-CTXCatalog.ps1](./New-CTXCatalog.ps1)

  Adds a new catalog to the site

+ [New-CTXDesktopGroup.ps1](./New-CTXDesktopGroup.ps1)

  Create a new desktop group for managing the brokering of groups of desktops

+ [New-CTXRebootSchedule.ps1](./New-CTXRebootSchedule.ps1)

  Creates a new reboot schedule for a desktop group

+ [Remove-CTXApplication.ps1](./Remove-CTXApplication.ps1)

  Deletes an application

+ [Remove-CTXApplicationFolder.ps1](./Remove-CTXApplicationFolder.ps1)

  Removes an admin folder

+ [Remove-CTXApplicationFolderMetaData.ps1](./Remove-CTXApplicationFolderMetaData.ps1)

  Deletes metadata from the admin folder

+ [Remove-CTXApplicationFromGroup.ps1](./Remove-CTXApplicationFromGroup.ps1)
  
  Removes application from a desktop group or application group

+ [Remove-CTXApplicationGroup.ps1](./Remove-CTXApplicationGroup.ps1)

  Remove application groups from the system, or break the association between an application group and a desktop group

+ [Remove-CTXApplicationGroupMetaData.ps1](./Remove-CTXApplicationGroupMetaData.ps1)

  Deletes Metadata from the Application Group object

+ [Remove-CTXCatalog.ps1](./Remove-CTXCatalog.ps1)

  Remove catalog from the site

+ [Remove-CTXCatalogMetadata.ps1](./Remove-CTXCatalogMetadata.ps1)

  Deletes Catalog Metadata from the Catalog objects

+ [Remove-CTXDesktopGroup.ps1](./Remove-CTXDesktopGroup.ps1)

  Remove desktop group from the system

+ [Remove-CTXDesktopGroupMetaData.ps1](./Remove-CTXDesktopGroupMetaData.ps1)

  Deletes Desktop Group Metadata from the Desktop Group object

+ [Remove-CTXRebootSchedule.ps1](./Remove-CTXRebootSchedule.ps1)

  Removes the reboot schedule

+ [Remove-CTXRebootScheduleMetadata.ps1](./Remove-CTXRebootScheduleMetadata.ps1)

  Deletes Metadata from the Reboot Schedule object

+ [Rename-CTXApplication.ps1](./Rename-CTXApplication.ps1)

  Renames an application

+ [Rename-CTXApplicationFolder.ps1](./Rename-CTXApplicationFolder.ps1)

  Renames a admin folder

+ [Rename-CTXApplicationGroup.ps1](./Rename-CTXApplicationGroup.ps1)

  Renames an application group

+ [Rename-CTXCatalog.ps1](./Rename-CTXCatalog.ps1)

  Renames a catalog

+ [Rename-CTXDesktopGroup.ps1](./Rename-CTXDesktopGroup.ps1)

  Renames a desktop group

+ [Rename-CTXRebootSchedule.ps1](./Rename-CTXRebootSchedule.ps1)

  Renames a reboot schedule

+ [Set-CTXApplication.ps1](./Set-CTXApplication.ps1)

  Changes properties of an application 

+ [Set-CTXApplicationFolderMetaData.ps1](./Set-CTXApplicationFolderMetaData.ps1)

  Creates or updates metadata for Admin Folder

+ [Set-CTXApplicationGroup.ps1](./Set-CTXApplicationGroup.ps1)

  Changes properties of application group

+ [Set-CTXApplicationGroupMetaData.ps1](./Set-CTXApplicationGroupMetaData.ps1)

  Creates or updates metadata for application group

+ [Set-CTXCatalog.ps1](./Set-CTXCatalog.ps1)

  Sets the properties of a catalog

+ [Set-CTXCatalogMetadata.ps1](./Set-CTXCatalogMetadata.ps1)

  Creates or updates metadata for Catalog

+ [Set-CTXDesktopGroup.ps1](./Set-CTXDesktopGroup.ps1)

  Adjusts the settings of a broker desktop group

+ [Set-CTXDesktopGroupMetaData.ps1](./Set-CTXDesktopGroupMetaData.ps1)

  Creates or updates metadata for desktop group

+ [Set-CTXRebootSchedule.ps1](./Set-CTXRebootSchedule.ps1)

  Updates the values of one or more desktop group reboot schedules

+ [Set-CTXRebootScheduleMetadata.ps1](./Set-CTXRebootScheduleMetadata.ps1)

  Creates or updates metadata for Reboot Schedule

+ [Start-CTXRebootCycle.ps1](./Start-CTXRebootCycle.ps1)

  Creates and starts a reboot cycle for each desktop group that contains machines from the specified catalog

+ [Start-CTXDesktopGroupRebootCycle.ps1](./Start-CTXDesktopGroupRebootCycle.ps1)

  Creates and starts a reboot cycle for each specified desktop group

+ [Stop-CTXRebootCycle.ps1](./Stop-CTXRebootCycle.ps1)

  Cancels the specified reboot cycle

+ [Test-CTXApplicationGroupNameAvailable.ps1](./Test-CTXApplicationGroupNameAvailable.ps1)

  Determine whether the proposed ApplicationGroup Name is available for use

+ [Test-CTXApplicationNameAvailable.ps1](./Test-CTXApplicationNameAvailable.ps1)

  Determine whether the proposed Application Name is available for use

+ [Test-CTXBrokerDBConnection.ps1](./Test-CTXBrokerDBConnection.ps1)

  Tests whether a database is suitable for use by the Citrix Broker Service

+ [Test-CTXDesktopGroupNameAvailable.ps1](./Test-CTXDesktopGroupNameAvailable.ps1)

  Determine whether the proposed DesktopGroup Name is available for use