# Administration

> Note: The use of the scripts requires the Citrix PowerShell SnapIns.

+ [Add-CTXMachine.ps1](./Add-CTXMachine.ps1)

  Adds a machine to a desktop group

+ [Add-CTXPermission.ps1](./Add-CTXPermission.ps1)

  Add permissions to the set of permissions of a role

+ [Add-CTXRight.ps1](./Add-CTXRight.ps1)

  Grants a given right to the specified administrator

+ [Add-CTXTag.ps1](./Add-CTXTag.ps1)

  Associate a tag with another object in the site

+ [Add-CTXUser.ps1](./Add-CTXUser.ps1)
  
  Creates an association between user and another object

+ [Disconnect-CTXSession.ps1](./Disconnect-CTXSession.ps1)
  
  Disconnect a session

+ [Get-CTXAdministratorMetadata.ps1](./Get-CTXAdministratorMetadata.ps1)

  Gets the metadata from Administrator

+ [Get-CTXAdministrators.ps1](./Get-CTXAdministrators.ps1)

  Gets administrators configured for this site

+ [Get-CTXEffectiveAdministrator.ps1](./Get-CTXEffectiveAdministrator.ps1)

  Retrieve the effective administrator objects for a user

+ [Get-CTXEffectiveRight.ps1](./Get-CTXEffectiveRight.ps1)

  Gets the set of Right objects associated with the current user

+ [Get-CTXMachine.ps1](./Get-CTXMachine.ps1)

  Gets machines belonging to this site

+ [Get-CTXMachineMetadata.ps1](./Get-CTXMachineMetadata.ps1)

  Gets Machine Metadata

+ [Get-CTXPermissionGroups.ps1](./Get-CTXPermissionGroups.ps1)

  Gets permission groups configured for the site

+ [Get-CTXPermissions.ps1](./Get-CTXPermissions.ps1)

  Gets permissions configured for the site

+ [Get-CTXRoleConfiguration.ps1](./Get-CTXRoleConfiguration.ps1)

  Gets roles configured for this site

+ [Get-CTXRoleMetaData.ps1](./Get-CTXRoleMetaData.ps1)

  Gets Role Metadata

+ [Get-CTXRoles.ps1](./Get-CTXRoles.ps1)

  Gets roles configured for this site

+ [Get-CTXScopeMetaData.ps1](./Get-CTXScopeMetaData.ps1)

  Gets Scope Metadata

+ [Get-CTXScopes.ps1](./Get-CTXScopes.ps1)

  Gets scopes configured for this site

+ [Get-CTXService.ps1](./Get-CTXService.ps1)

  Gets the service record entries for the Delegated Admin Service

+ [Get-CTXServiceAddedCapability.ps1](./Get-CTXServiceAddedCapability.ps1)

  Gets any added capabilities for the Delegated Admin Service on the controller

+ [Get-CTXServiceInstance.ps1](./Get-CTXServiceInstance.ps1)

  Gets the service instance entries for the DelegatedAdmin Service

+ [Get-CTXServiceMetadata.ps1](./Get-CTXServiceMetadata.ps1)

  Gets metadata from the given Service

+ [Get-CTXServiceStatus.ps1](./Get-CTXServiceStatus.ps1)

  Gets the service record entries for the Delegated Admin Service

+ [Get-CTXSessions.ps1](./Get-CTXSessions.ps1)
  
  Gets a list of sessions

+ [Get-CTXTag.ps1](./Get-CTXTag.ps1)

  Gets one or more tags

+ [Get-CTXUsers.ps1](./Get-CTXUsers.ps1)

  Gets users configured for this site

+ [Group-CTXMachines.ps1](./Group-CTXMachines.ps1)

  Groups and counts machines with the same value for a specified property

+ [Import-CTXRoleConfiguration.ps1](./Import-CTXRoleConfiguration.ps1)

  Imports role configuration data into the Delegated Administration Service

+ [New-CTXAdministrator.ps1](./New-CTXAdministrator.ps1)

  Adds a new administrator to the site

+ [New-CTXMachine.ps1](./New-CTXMachine.ps1)

  Adds a machine that can be used to run desktops and applications

+ [New-CTXRole.ps1](./New-CTXRole.ps1)

  Adds a new custom role to the site

+ [New-CTXScope.ps1](./New-CTXScope.ps1)

  Adds a new scope to the site

+ [New-CTXTag.ps1](./New-CTXTag.ps1)

  Adds a new scope to the site

+ [New-CTXUser.ps1](./New-CTXUser.ps1)
  
  Creates a new tag

+ [Remove-CTXAdministrator.ps1](./Remove-CTXAdministrator.ps1)

  Removes administrator from the site

+ [Remove-CTXAdministratorMetadata.ps1](./Remove-CTXAdministratorMetadata.ps1)

  Removes metadata from the given administrator

+ [Remove-CTXMachine.ps1](./Remove-CTXMachine.ps1)

  Removes the machine from its desktop group or catalog

+ [Remove-CTXMachineMetadata.ps1](./Remove-CTXMachineMetadata.ps1)

  Removes metadata from the given machine

+ [Remove-CTXRight.ps1](./Remove-CTXRight.ps1)

  Removes rights from an administrator

+ [Remove-CTXPermission.ps1](./Remove-CTXPermission.ps1)

  Remove permissions from the set of permissions of a role

+ [Remove-CTXRole.ps1](./Remove-CTXRole.ps1)

  Removes a role from the site

+ [Remove-CTXUser.ps1](./Remove-CTXUser.ps1)

  Remove broker user object from another broker object

+ [Remove-CTXRoleMetaData.ps1](./Remove-CTXRoleMetaData.ps1)

  Removes metadata from the given Role

+ [Remove-CTXScope.ps1](./Remove-CTXScope.ps1)

  Removes a scope from the site

+ [Remove-CTXScopeMetaData.ps1](./Remove-CTXScopeMetaData.ps1)

  Removes metadata from the given Scope

+ [Remove-CTXServiceMetadata.ps1](./Remove-CTXServiceMetadata.ps1)

  Removes metadata from the given Service

+ [Remove-CTXTag.ps1](./Remove-CTXTag.ps1)

  Removes tag to object associations or deletes tags from the site altogether

+ [Remove-CTXUser.ps1](./Remove-CTXUser.ps1)

  Remove broker user object from another broker object

+ [Rename-CTXRole.ps1](./Rename-CTXRole.ps1)

  Rename a role

+ [Rename-CTXScope.ps1](./Rename-CTXScope.ps1)

  Rename a scope

+ [Rename-CTXTag.ps1](./Rename-CTXTag.ps1)

  Renames a tag

+ [Reset-CTXEnabledFeatureList.ps1](./Reset-CTXEnabledFeatureList.ps1)

  Requests a refresh of the list of enabled features

+ [Reset-CTXServiceGroupMembership.ps1](./Reset-CTXServiceGroupMembership.ps1)

  Reloads the access permissions and configuration service locations for the Delegated Admin Service

+ [Set-CTXAdministrator.ps1](./Set-CTXAdministrator.ps1)

  Sets the properties of an administrator

+ [Set-CTXAdministratorMetadata.ps1](./Set-CTXAdministratorMetadata.ps1)

  Adds or updates metadata on the given Administrator

+ [Set-CTXMachine.ps1](./Set-CTXMachine.ps1)

  Sets properties on a machine

+ [Set-CTXMachineMetadata.ps1](./Set-CTXMachineMetadata.ps1)

  Adds or updates metadata on the given machine

+ [Set-CTXRole.ps1](./Set-CTXRole.ps1)

  Set the properties of a role

+ [Set-CTXRoleMetaData.ps1](./Set-CTXRoleMetaData.ps1)

  Creates or updates metadata for role

+ [Set-CTXScope.ps1](./Set-CTXScope.ps1)

  Set the properties of a scope

+ [Set-CTXScopeMetaData.ps1](./Set-CTXScopeMetaData.ps1)

  Creates or updates metadata for scope

+ [Set-CTXServiceMetadata.ps1](./Set-CTXServiceMetadata.ps1)

  Adds or updates metadata on the given Service

+ [Set-CTXTag.ps1](./Set-CTXTag.ps1)

  Sets the properties of a tag

+ [Stop-CTXSession.ps1](./Stop-CTXSession.ps1)

  Stop or log off a session

+ [Test-CTXAccess.ps1](./Test-CTXAccess.ps1)

  Retrieves the scopes where the specified operation is permitted

+ [Test-CTXMachineNameAvailable.ps1](./Test-CTXMachineNameAvailable.ps1)

  Determine whether the proposed Machine MachineName is available for use