﻿#Requires -Version 5.0

<#
    .SYNOPSIS
        Creates a new user object
    
    .DESCRIPTION  

    .NOTES
        This PowerShell script was developed and optimized for ScriptRunner. The use of the scripts requires ScriptRunner. 
        The customer or user is authorized to copy the script from the repository and use them in ScriptRunner. 
        The terms of use for ScriptRunner do not apply to this script. In particular, ScriptRunner Software GmbH assumes no liability for the function, 
        the use and the consequences of the use of this freely available script.
        PowerShell is a product of Microsoft Corporation. ScriptRunner is a product of ScriptRunner Software GmbH.
        © ScriptRunner Software GmbH

    .COMPONENT
        Requires the library script CitrixLibrary.ps1
        Requires PSSnapIn Citrix*

    .LINK
        https://github.com/scriptrunner/ActionPacks/blob/master/Citrix/Administration
        
    .Parameter SiteServer
        [sr-en] Specifies the address of a XenDesktop controller. 
        This can be provided as a host name or an IP address
        [sr-de] Name oder IP Adresse des XenDesktop Controllers

    .Parameter Name
        [sr-en] Name of the user or group (DOMAIN\Name)
        [sr-de] Benutzer- oder Gruppen-Name (Domäne\Name)

    .Parameter SID
        [sr-en] SID of the user or group
        [sr-de] Benutzer oder Gruppen SID
    #>

param(
    [Parameter(Mandatory = $true,ParameterSetName = 'byId')]
    [string]$SID,
    [Parameter(ParameterSetName = 'byName')]
    [string]$Name,
    [Parameter(ParameterSetName = 'byId')]
    [Parameter(ParameterSetName = 'byName')]
    [string]$SiteServer
)                                                            

try{ 
    [string[]]$Properties = @('Name','FullName','HomeZoneName','UPN','SID')
    StartCitrixSessionAdv -ServerName ([ref]$SiteServer)

    [hashtable]$cmdArgs = @{'ErrorAction' = 'Stop'
                            'AdminAddress' = $SiteServer
                            }    
    
    if($PSCmdlet.ParameterSetName -eq 'byId'){
        $cmdArgs.Add('SID',$SID)
    }
    else{
        $cmdArgs.Add('Name',$Name)
    }
    
    $ret = New-BrokerUser @cmdArgs | Select-Object $Properties
    if($SRXEnv) {
        $SRXEnv.ResultMessage = $ret
    }
    else{
        Write-Output $ret
    }
}
catch{
    throw 
}
finally{
    CloseCitrixSession
}