# Manage Storage and Blobs

> Note: The use of the scripts requires the PowerShell Module Az.Storage and Az.StorageSync

+ [Get-AzStorageAccounts.ps1](./Get-AzStorageAccounts.ps1)

    Gets the storage accounts

+ [Get-AzStorageBlobContent.ps1](./Get-AzStorageBlobContent.ps1)

    Downloads a storage blob

+ [Get-AzStorageBlobs.ps1](./Get-AzStorageBlobs.ps1)

    Gets blobs in a container

+ [Get-AzStorageBlobServiceProperty.ps1](./Get-AzStorageBlobServiceProperty.ps1)

    Gets service properties for Azure Storage Blob services

+ [Get-AzStorageContainers.ps1](./Get-AzStorageContainers.ps1)

    Gets the storage containers

+ [Get-AzStorageContainerStoredAccessPolicy.ps1](./Get-AzStorageContainerStoredAccessPolicy.ps1)

    Gets the stored access policy or policies for an Azure storage container

+ [Get-AzStorageCORSRule.ps1](./Get-AzStorageCORSRule.ps1)

    Gets CORS rules for a Storage service type

+ [Get-AzStorageObjectReplicationPolicy.ps1](./Get-AzStorageObjectReplicationPolicy.ps1)

    Gets or lists object replication policy of a Storage account

+ [Get-AzStorageQueue.ps1](./Get-AzStorageQueue.ps1)

    Lists storage queues

+ [Get-AzStorageQueueStoredAccessPolicy.ps1](./Get-AzStorageQueueStoredAccessPolicy.ps1)

    Gets the stored access policy or policies for an Azure storage queue

+ [Get-AzStorageServiceLoggingProperty.ps1](./Get-AzStorageServiceLoggingProperty.ps1)

    Gets logging properties for Azure Storage services

+ [Get-AzStorageServiceMetricsProperty.ps1](./Get-AzStorageServiceMetricsProperty.ps1)

    Gets metrics properties for the Azure Storage service

+ [Get-AzStorageServiceProperty.ps1](./Get-AzStorageServiceProperty.ps1)

    Gets properties for Azure Storage services

+ [Get-AzStorageShare.ps1](./Get-AzStorageShare.ps1)

    Gets a list of file shares

+ [Get-AzStorageTable.ps1](./Get-AzStorageTable.ps1)

    Lists storage tables

+ [Get-AzStorageTableStoredAccessPolicy.ps1](./Get-AzStorageTableStoredAccessPolicy.ps1)

    Gets the stored access policy or policies for an Azure storage table

+ [Get-AzStorageUsage.ps1](./Get-AzStorageUsage.ps1)

    Gets the Storage resource usage of the current subscription

+ [New-AzStorageContainer.ps1](./New-AzStorageContainer.ps1)

    Creates an Azure storage container

+ [New-AzStorageShare.ps1](./New-AzStorageShare.ps1)

    Creates a file share

+ [New-AzStorageTable.ps1](./New-AzStorageTable.ps1)

    Creates a file storage table

+ [Remove-AzStorageContainer.ps1](./Remove-AzStorageContainer.ps1)

    Removes the specified storage container

+ [Remove-AzStorageShare.ps1](./Remove-AzStorageShare.ps1)

    Deletes a file share

+ [Remove-AzStorageTable.ps1](./Remove-AzStorageTable.ps1)

    Removes a storage table

+ [Set-AzStorageBlobContent.ps1](./Set-AzStorageBlobContent.ps1)

    Uploads a local file to an Azure Storage blob