# Action Pack for Azure KeyVault

> Note: The use of the scripts requires the PowerShell Module Az.KeyVault

+ [Add-AzKeyVaultCertificate.ps1](./Add-AzKeyVaultCertificate.ps1)

    Adds a certificate to a key vault

+ [Add-AzKeyVaultCertificateContact.ps1](./Add-AzKeyVaultCertificateContact.ps1)

    Adds a contact for certificate notifications

+ [Add-AzKeyVaultKey.ps1](./Add-AzKeyVaultKey.ps1)

    Creates a key in a key vault or imports a key into a key vault

+ [Backup-AzKeyVaultCertificate.ps1](./Backup-AzKeyVaultCertificate.ps1)

    Backs up a certificate in a key vault

+ [Backup-AzKeyVaultKey.ps1](./Backup-AzKeyVaultKey.ps1)
    
    Backs up a key in a key vault

+ [Backup-AzKeyVaultSecret.ps1](./Backup-AzKeyVaultSecret.ps1)
    
    Backs up a secret in a key vault

+ [Get-AzKeyVault.ps1](./Get-AzKeyVault.ps1)

    Gets key vaults

+ [Get-AzKeyVaultCertificate.ps1](./Get-AzKeyVaultCertificate.ps1)

    Gets the certificates from key vault

+ [Get-AzKeyVaultCertificateContact.ps1](./Get-AzKeyVaultCertificateContact.ps1)

    Gets contacts that are registered for certificate notifications for a key vault

+ [Get-AzKeyVaultCertificateIssuer.ps1](./Get-AzKeyVaultCertificateIssuer.ps1)

    Gets a certificate issuer for a key vault

+ [Get-AzKeyVaultCertificateOperation.ps1](./Get-AzKeyVaultCertificateOperation.ps1)

    Gets the status of a certificate operation

+ [Get-AzKeyVaultCertificatePolicy.ps1](./Get-AzKeyVaultCertificatePolicy.ps1)

    Gets the certificate policy from key vault

+ [Get-AzKeyVaultKey.ps1](./Get-AzKeyVaultKey.ps1)

    Gets Key Vault keys

+ [Get-AzKeyVaultKeyRotationPolicy.ps1](./Get-AzKeyVaultKeyRotationPolicy.ps1)

    Gets the key rotation policy for the specified key in Key Vault

+ [Get-AzKeyVaultSecret.ps1](./Get-AzKeyVaultSecret.ps1)

    Gets the secrets in a key vault

+ [Get-AzKeyVaultSecretValue.ps1](./Get-AzKeyVaultSecretValue.ps1)

    Gets the secret value in a key vault

+ [Import-AzKeyVaultCertificate.ps1](./Import-AzKeyVaultCertificate.ps1)

    Imports a certificate to key vault

+ [Invoke-AzKeyVaultKeyRotation.ps1](./Invoke-AzKeyVaultKeyRotation.ps1)

    Creates a new key version in Key Vault, stores it, then returns the new key

+ [New-AzKeyVaultSecret.ps1](./New-AzKeyVaultSecret.ps1)

    Creates a secret in a key vault

+ [Remove-AzKeyVaultAccessPolicy.ps1](./Remove-AzKeyVaultAccessPolicy.ps1)

    Removes all permissions for a user or application from a key vault

+ [Remove-AzKeyVaultCertificate.ps1](./Remove-AzKeyVaultCertificate.ps1)

    Removes a certificate from a key vault

+ [Remove-AzKeyVaultCertificateContact.ps1](./Remove-AzKeyVaultCertificateContact.ps1)

    Deletes a contact that is registered for certificate notifications from a key vault

+ [Remove-AzKeyVaultCertificateIssuer.ps1](./Remove-AzKeyVaultCertificateIssuer.ps1)

    Gets a certificate issuer for a key vault

+ [Remove-AzKeyVaultCertificateOperation.ps1](./Remove-AzKeyVaultCertificateOperation.ps1)

    Deletes a certificate operation from a key vault

+ [Remove-AzKeyVaultKey.ps1](./Remove-AzKeyVaultKey.ps1)

    Deletes a key in a key vault

+ [Remove-AzKeyVaultSecret.ps1](./Remove-AzKeyVaultSecret.ps1)

    Deletes a secret in a key vault

+ [Restore-AzKeyVaultCertificate.ps1](./Restore-AzKeyVaultCertificate.ps1)

    Restores a certificate in a key vault from a backup file

+ [Restore-AzKeyVaultKey.ps1](./Restore-AzKeyVaultKey.ps1)

    Creates a key in a key vault from a backed-up key

+ [Restore-AzKeyVaultSecret.ps1](./Restore-AzKeyVaultSecret.ps1)

    Creates a secret in a key vault from a backed-up secret

+ [Set-AzKeyVaultAccessPolicy.ps1](./Set-AzKeyVaultAccessPolicy.ps1)

    Grants or modifies existing permissions for a user

+ [Set-AzKeyVaultKey.ps1](./Set-AzKeyVaultKey.ps1)

    Updates the attributes of a key in a key vault

+ [Set-AzKeyVaultSecret.ps1](./Set-AzKeyVaultSecret.ps1)

    Updates the attributes of a secret in a key vault

+ [Undo-AzKeyVaultCertificateRemoval.ps1](./Undo-AzKeyVaultCertificateRemoval.ps1)

    Recovers a deleted certificate in a key vault into an active state

+ [Undo-AzKeyVaultKeyRemoval.ps1](./Undo-AzKeyVaultKeyRemoval.ps1)

    Recovers a deleted key in a key vault into an active state

+ [Undo-AzKeyVaultSecretRemoval.ps1](./Undo-AzKeyVaultSecretRemoval.ps1)

    Recovers a deleted secret in a key vault into an active state