<div align="center">
    <a href="https://github.com/scottgriv/PRG-Personal-Repository-Guidelines" target="_blank">
        <img src="https://github.com/scottgriv/PRG-Personal-Repository-Guidelines/raw/main/docs/images/PRG.png" width="200" height="200"/>
    </a>
</div>

<h1 align="center">Personal Repository Guidelines (PRG) Connection File</h1>

This file is used to connect this repository to the **PRG** project categorization system.

---------------

## Project Information

**Repository Tier:** Bronze <br>
**Technology:** Kotlin, Android Studio, Android <br>
**Category:** Mobile Application <br>
**Order:** 39 <br>

## Parameters

- **Repository Tier (Required):** Platinum, Gold, Silver, Bronze, or Optimized (required for PRG - if you don't add a tier it will be displayed as "Optimized" by default)
- **Technologies (Optional):** List the technologies used to build your project here (e.g. Markdown, API, GitHub Actions, Jekyll, Python, DataTables, etc.)
- **Category (Optional):** List categories for your project here (e.g. Web, Mobile, API, etc.)
- **Order (Optional):** By default, repos are ranked by Tier, then Create Date, but you can also add an integer (e.g. 1, 2, 12, etc.) to sort in between Tier and Create Date

## How this works

This file connects this repository to the **PRG** guideline and categorization system.
- Include this file in your projects root folder for this repo to properly connect to your PRG system.
- Follow the instructions in the [PRG-Personal-Repository-Guidelines - Table Generator Guide](https://github.com/scottgriv/PRG-Personal-Repository-Guidelines/blob/main/categories/table_generator_guide.md) for more information on how to use the **PRG** system and **PRG Connection File (PRGCF)**.

> [!CAUTION]
> Lines 15-18 above are mapped in the `scripts/project_tier_table_generator.py` script for the PRG system. Do not move or change these lines without adjusting the script to account for this change.

## Resources

- Visit the official [Personal Repository Guidelines (PRG)](https://github.com/scottgriv/PRG-Personal-Repository-Guidelines) repository for more details.
- Visit an example of the [PRG Portfolio](https://prgportfolio.com) website to see how the **PRG** system can be used to create a portfolio of your projects.
- Visit the [PRG Website](https://github.com/scottgriv/PRG-Website) repository to add your GitHub account name to the **PRG Showcase**.
- Visit the official [PRG Website](https://prgoptimized.com) view the current **PRG Showcase**.

<p align="center">
    <a href="https://github.com/scottgriv/PRG-Personal-Repository-Guidelines" target="_blank">
        <img src="https://github.com/scottgriv/PRG-Personal-Repository-Guidelines/raw/main/docs/images/prg_optimized.png" alt="PRG Repository" width="138" height="51" />
    </a>
</p>