---
layout: page
title: Tutorials
permalink: /tutorials/
nav_order: 1
has_children: true
---

# Tutorials

Do you have a pile of scientific Python scripts or Jupyter notebooks that are
becoming unwieldy? Are changes to some parts of your code accidentally breaking
other parts of your code? Do you want to present them in a more maintainable,
reusable, and shareable form?

This tutorial aims to help scientists who write code find good practices and
standard tools, and to help small- and medium-sized scientific software projects
start off on the right foot.

Keeping in mind that too much software infrastructure can be overwhelming to
those who haven't yet encountered the need for it, we introduce only the core
essentials in this opinionated tutorial. From there, we recommend looking
through the section on [principles]({% link pages/principles/index.md %}). As
your project grows you may find some good use for the more specific and advanced
topics covered in the [guides]({% link pages/guides/index.md %}).
