#ifndef MU_TEST_FRAMEWORK
#define MU_TEST_FRAMEWORK

#include "platform/include_first.h"

#include <stdio.h>
#include <stdlib.h>

#define mu_assert(condition)                                            \
    do {                                                                \
        if (!(condition)) {                                             \
            mu_test_status = 1;                                         \
            fprintf(stderr,                                             \
                    "Test assertion failed:\n"                          \
                    "  Condition: %s\n"                                 \
                    "  File:      %s\n"                                 \
                    "  Function:  %s\n"                                 \
                    "  Line:      %i\n",                                \
                    #condition, __FILE__, __func__, __LINE__);          \
            exit(1);                                                    \
        }                                                               \
    } while (0)

volatile static int mu_test_status = 0;

#endif /* MU_TEST_FRAMEWORK */
