# Sales Performance Analysis
## Project Overview
This analysis evaluates the sales performance across various categories, payment modes, and sale types for the years 2021 and 2022. The goal is to identify trends, disparities, and areas for improvement to enhance overall business profitability.
![Screenshot 2024-11-11 005852X](https://github.com/user-attachments/assets/38c768b0-7094-441c-ac7d-453927d55bff)
## Objectives
- Understand Sales Performance: Assess overall sales performance over the two years.
- Identify Best-Selling Products: Determine which products and categories are the top sellers.
- Profitability Analysis: Analyze profit margins and identify the most profitable products and categories.
- Sales Volume Analysis: Examined the sales volume across different periods and sales avenues.
- Payment Mode Preferences: Discover trends in customer payment modes.
- Sales Method Effectiveness: Compare the effectiveness of different sales methods (direct, online, and wholesale).
## Methods
-	Data was obtained from Microsoft
-	Data cleaning and transformation were  done with PowerQuery
-	Data modelling was done in PowerBI
-	Data analyses were done with Excel,  PowerBI, SQL
-	Data visualisation and report done with PowerBI
## Key Performance Indicators (KPIs)
- Total Sales: The overall sales amount for the period was determined.
- Total Profit: The overall profit generated was evaluated.
- Sales Growth Rate: Sales growth rate year-over-year and month-over-month were calculated.
- Profit Margin: Profit margin for products and categories were determined.
- Top Products by Sales Volume: Top products based on sales volume were identified.
- Sales by Category: Sales performance across different product categories were measured.
- Sales by Payment Mode: Distribution of sales across different payment modes were analysed.
- Sales by Method: The effectiveness of each sales avenue (direct, online, wholesale) were determined.
- Customer Retention Rate: Assess the percentage of repeat customers
- Average Order Value (AOV): The average amount spent per order was calculated
## Key Findings
### Total Sales and Profit
- Total Sales: The business generated $401.41K in total sales, exceeding the target of $350K, indicating strong performance.
- Profit: A total profit of $68.91K was achieved, highlighting effective cost management.
### Sales Quantity:
- Total Sales Quantity: 4,280 units were sold, reflecting robust demand for the products.
### Sales by Payment Mode
- Cash Sales: Accounted for 48.3% of total sales.
- Online Sales: Slightly higher making up 51.7% of total sales, emphasizing the importance of online sales channels.
![Screenshot 2024-11-11 005842Xx](https://github.com/user-attachments/assets/c275f8aa-d010-4b8f-a44e-85441e50985f)
### Sales and % Margin by Month
- Monthly Sales Trends: January shows the highest sales, indicating a strong start to the year.
- Percentage Margin: Peaks in May and dips in June, suggesting fluctuations in profitability throughout the year.
### Sales by Category
- Category04: Leads with the highest sales approaching $100K.
- Category02 and Category05: Follow closely with slightly lower sales.
- Category01 and Category03: Lowest sales, with Category03 being the lowest.
### Quantity by Category
- Category04: Highest quantity sold, exceeding 1,000 units.
- Category02 and Category05: Follow with slightly lower quantities.
- Category01 and Category03: Lowest quantities sold, with Category03 being the lowest.
### Total Margin by Category
- Category04: Highest total margin.
- Category02 and Category05: Follow closely behind.
- Category01 and Category03: Lowest margins, indicating potential areas for improvement.
  ![Screenshot 2024-11-11 005907Xx](https://github.com/user-attachments/assets/c43bab9d-e10c-450a-8375-fb5061e898cf)
### Margin by Category (Detailed):
- Category02 and Category04: Each contributes significantly to the total margin at 25.5%.
- Category05: Close follow-up with 24.2% of the total margin.
- Category01 and Category03: Lower contributions, especially Category03 at 10.3%.
- 
![Screenshot 2024-11-26 230833x](https://github.com/user-attachments/assets/54accbc5-ffaf-4a5a-a85b-f07dc0f7efdb)
## Overall Observations
- Achieving Targets: The business has successfully met and exceeded its sales target, demonstrating effective sales strategies.
- Online Sales Importance: Online sales slightly surpass cash sales, underscoring the growing importance of digital sales channels.
- Top-Performing Categories: Category04 is the most profitable and highest-selling category, followed by Category02 and Category05.
- Areas for Improvement: Categories 01 and 03 consistently show lower performance in terms of sales and margin, indicating potential areas for strategic enhancement.
## Recommendations
- Enhance Online Sales Strategies: Leverage the success of online sales channels to further increase revenue.
- Implement targeted marketing campaigns to boost online sales.
- Focus on Underperforming Categories: Develop strategies to improve sales and margins for Categories 01 and 03. Consider product enhancements, targeted promotions, or cost optimization for these categories.
- Monitor Monthly Trends: Analyze monthly sales and margin trends to identify and address any seasonal fluctuations.
- Implement strategies to maintain profitability during lower-margin months.
- Maximize Category04 Success: Continue to invest in and promote Category04, leveraging its high sales and margin contributions.
- Explore opportunities to replicate successful strategies from Category04 in other categories.

This comprehensive analysis provides a clear understanding of the sales dynamics, helping to identify areas for potential improvement and ensuring informed business decisions to enhance overall profitability and growth.
