# Let's Cook

### Welcome to Let's! This web application allows users to manage their recipes, including adding, editing, and deleting recipes, and saving other recipes.

## Features

- **View Recipes:** See a list of recipes with brief details.
- **Add New Recipe:** Create a new recipe with details like name, description, ingredients, instructions, and cooking time.
- **Edit and Update:** Modify existing recipes with ease.
- **Delete Recipe:** Remove recipes that you no longer need.
- **Save Other Recipes:** Bookmark or save recipes from other users for future reference.
- **Recipe Details:** View more details of a recipe, including a larger image and additional information.

## Screenshots

![img](https://i.postimg.cc/ZKVZ0031/Untitled-design.png)
![img](https://i.postimg.cc/x16KsGmt/Untitled-design-1.png)
![img](https://i.postimg.cc/QtT1xRyy/Untitled-design-2.png)
![img](https://i.postimg.cc/wT34cBnK/Untitled-design-3.png)

## Follow the steps below to set up and install the project dependencies.

### Client

1. Navigate to the client directory:
   ```bash
   cd client
2. Install client dependencies:
   ```bash
   npm install

### Server

1. Navigate to the server directory:
   ```bash
   cd server
2. Install server dependencies:
   ```bash
   npm install

### Running the Project
Follow the steps below to run the project in development mode.

Development Mode

1. Run the project in development mode:
   ```bash
   npm run dev
   
2. The client is available at http://localhost:5173.
3. The server is available at http://localhost:3001.

### Building the Project
   ```bash
   npm run build
```

### Contributing to Let's Cook

We welcome contributions from the community to help improve and expand the Let's Cook. Whether you're a seasoned developer or just starting out, there are several ways you can contribute.

## Getting Started

<ol>
    <li>
    Fork the project repository on GitHub.
    </li>
    <li>Clone your forked repository to your local machine.</li>
    <li>Install the necessary dependencies using npm install.</li>
</ol>

## Submitting a Pull Request

<ol>
    <li>
    Create a new branch for your contribution: git checkout -b feature/your-feature-name.
    </li>
    <li>Make your changes and test them thoroughly.</li>
    <li>Commit your changes with descriptive commit messages.</li>
    <li>Push your branch to your forked repository: git push origin feature/your-feature-name.</li>
    <li>Open a pull request to the original repository's main branch, explaining your changes and their benefits.</li>
</ol>
