---
name: Bug report
about: Create a report to help us improve

---

## Bug Report
Note that, the bug you're reporting may have registered in the [issues](https://github.com/samchon/typia/search?type=issues) by another user. Even the bug you're reporting may have been fixed in the `@next` version. In such reasons, I recommend you to check the old [issues](https://github.com/samchon/typia/search?type=issues) and reproduct your code with the `@next` version before publishing the bug reporting issue.

```bash
`npm install --save-dev typia@next`
```

When the same error occurs even in the `@next` version, then please fill the below template:



### 📝 Summary
Write a short summary of the bug in here.

  - **Typia Version**: 4.1.2
  - **Expected behavior**: 
  - **Actual behavior**: 

Write detailed description in here.



### ⏯ Playground Link
https://typia.io/playground

Visit above playground and write code occuring the bug.

After that, copy and paste link address of that.

> #### Example Link
> https://typia.io/playground/?script=JYWwDg9gTgLgBDAnmYBDOAzKERwERIqp4DcAUGcAHYwCmUGqAxrXAJICytIARvXAG8ycEXAD0AKglxhouNIACGaCFTwAruuAATGXPli9onQC44AZxhRqAc3KyRk6Q5GLlUVfG6pgAGyOiEoYu3n5mltZUdhRyTi7ycAqErFo08Yog1KDquABMAAzpibQAHky+6ubAAG60HKgl2bgAjPmF+kEuqDa0ZlQ5fFDkcmCoULQ0Zpzcg3AAPnD9vr7DokwAFn7a41RTXLz0ANoAuuQAvhRiYgC0t9dkV+wAyg83d2SEaAB0TONqtGxzAAeaYHKAAPgAFABKchAA



### 💻 Code occuring the bug
```typescript
import typia from "typia";

/* Demonstration code occuring the bug you're reporting */
```
