const locale = {
  'zh-cn': {
    year: '年',
    month: '月',
    day: '日',
    weekTitle: ['日', '一', '二', '三', '四', '五', '六'],
    monthTitle: ['一月', '二月', '三月', '四月', '五月', '六月', '七月', '八月', '九月', '十月', '十一月', '十二月'],
    dayTipMap: {
      FULL: '全天',
      AM: '上午',
      PM: '下午',
    },
    today: '今天',
    duration: {
      start: '开始',
      end: '结束',
    },
    button: {
      confirm: '确定',
      cancel: '取消',
      clear: '重置',
    },
    dayCalendarMonthTitleFormat: 'yyyy年MM月', // 日期面板中的月份title
    cascadeToastTip: {
      start: '请选择开始日期',
      end: '请选择结束日期',
    },
    holiday: '休',
    workday: '班',
  },
  'en-us': {
    year: 'year',
    month: 'month',
    day: 'day',
    weekTitle: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
    monthTitle: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
    dayTipMap: {
      FULL: 'FULL',
      AM: 'AM',
      PM: 'PM',
    },
    today: 'Today',
    duration: {
      start: 'Start',
      end: 'End',
    },
    button: {
      confirm: 'OK',
      cancel: 'Cancel',
      clear: 'Reset',
    },
    dayCalendarMonthTitleFormat: 'yyyy-MM',
    cascadeToastTip: {
      start: 'please tap for start',
      end: 'please tap for end',
    },
    holiday: 'H',
    workday: 'W',
  },
};

export default locale;
