% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{weight_scheme_cum_temporal}
\alias{weight_scheme_cum_temporal}
\title{Weight Cumulative Temporal Projection Scheme}
\usage{
weight_scheme_cum_temporal(temporally_ordered_projected_graph)
}
\arguments{
\item{temporally_ordered_projected_graph}{A temporally row-wise ordered table
semi-processed bipartite projection network resulting
from \code{\link{temporal_graph_projection}} when specifying
weight_scheme_function = NA and lag = all_lag.}
}
\description{
This weight scheme sums the deleted node adjacent edges when re-wired
in the projection graph that *occur before* the temporal edge. See the
in line documentation for details.
}
\details{
Note this function assumes the rows of `temporally_ordered_projected_graph`
are temporally ordered. This property is only guaranteed by the
\code{\link{temporal_graph_projection}} function if `lag = "all_lag"`. For
`lag=one_lag`, use \code{\link{weight_scheme_sum_edges}} or
\code{\link{weight_scheme_count_deleted_nodes}}.

Refer to this weight scheme unit tests for examples.
}
\references{
M. Joblin, W. Mauerer, S. Apel,
J. Siegmund and D. Riehle, "From Developer Networks
to Verified Communities: A Fine-Grained Approach,"
2015 IEEE/ACM 37th IEEE International Conference on
Software Engineering, Florence, 2015, pp. 563-573,
doi: 10.1109/ICSE.2015.73.
}
\seealso{
Other weight_scheme: 
\code{\link{weight_scheme_count_deleted_nodes}()},
\code{\link{weight_scheme_pairwise_cum_temporal}()}
}
\concept{weight_scheme}
