% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{weight_scheme_count_deleted_nodes}
\alias{weight_scheme_count_deleted_nodes}
\title{Weight Number of Deleted Nodes Projection Scheme}
\usage{
weight_scheme_count_deleted_nodes(projected_graph)
}
\arguments{
\item{projected_graph}{A semi-processed bipartite projection network resulting
from \code{\link{bipartite_graph_projection}} when specifying
weight_scheme_function = NA.}
}
\description{
This weight scheme counts the number of deleted nodes for
every pair of adjacent edges, and uses it as the projection
edge weight.
}
\details{
For example, assume a graph which contains commit A and
commit B. Additionally, assume file1, file2, and file3 to
connect to commit A. And file2 and file3 to connect to
commit B.

If we wish to know the co-change metric, i.e. how many
times each pair of file were modified in the same commit,
then we may obtain it by counting the number of deleted nodes.

In this example the edges  (file1,file2), (file2,file3), and
(file1,file3) receive a contribution of weight 1 from the
deleted commit A, and (file2,file3) receive a contribution of
weight 1 from the deleted commit B.

Thus, the weights would be (file1,file2) = 1, (file2,file3) = 2,
and (file2,file3) = 1. In other words, in this example file2
and file3 have a co-change of 2, and the remaining pairs a
co-change of 1.
}
\seealso{
Other weight_scheme: 
\code{\link{weight_scheme_cum_temporal}()},
\code{\link{weight_scheme_pairwise_cum_temporal}()}
}
\concept{weight_scheme}
