% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dv8.R
\name{transform_temporal_gitlog_to_adsmj}
\alias{transform_temporal_gitlog_to_adsmj}
\title{Transform parsed git repo into an author dsm.json file.}
\usage{
transform_temporal_gitlog_to_adsmj(project_git, adsmj_path, is_sorted = FALSE)
}
\arguments{
\item{project_git}{A parsed git project by \code{\link{parse_gitlog}}.}

\item{adsmj_path}{the path to save the author dsm (*-adsm.json).}

\item{is_sorted}{whether to sort the variables (filenames) in the adsm.json file (optional).}
}
\description{
Converts a temporal gitlog table into an *-adsm.json.
In the adsm.json, the Variables are all the authors under analysis
(rows/columns in dependency matrix) and the Cells (matrix cell) contain all the relations of
 variable (src & dest) pairs. The Collaborate value is the number of times the src author and dest author changed the same file.
}
\seealso{
\code{\link{parse_gitlog}} to get a table of a parsed git project needed as input into \code{\link{transform_gitlog_to_hdsmj}},
\code{\link{transform_gitlog_to_hdsmj}} to perform a similar transformation into a *-dsm.json using a gitlog,
\code{\link{transform_dependencies_to_sdsmj}} to perform a similar transformation into a *-dsm.json using dependencies from Depends,
\code{\link{graph_to_dsmj}} to generate a *-dsm.json file.

Other edgelists: 
\code{\link{transform_commit_message_id_to_network}()},
\code{\link{transform_cve_cwe_file_to_network}()},
\code{\link{transform_dependencies_to_network}()},
\code{\link{transform_dependencies_to_sdsmj}()},
\code{\link{transform_gitlog_to_bipartite_network}()},
\code{\link{transform_gitlog_to_entity_bipartite_network}()},
\code{\link{transform_gitlog_to_entity_temporal_network}()},
\code{\link{transform_gitlog_to_hdsmj}()},
\code{\link{transform_gitlog_to_temporal_network}()},
\code{\link{transform_reply_to_bipartite_network}()},
\code{\link{transform_understand_dependencies_to_network}()}

Other dv8: 
\code{\link{dependencies_to_sdsmj}()},
\code{\link{dv8_clsxb_to_clsxj}()},
\code{\link{dv8_clsxj_to_clsxb}()},
\code{\link{dv8_depends_to_sdsmj}()},
\code{\link{dv8_dsmj_to_dsmb}()},
\code{\link{dv8_hdsmb_sdsmb_to_mdsmb}()},
\code{\link{dv8_mdsmb_to_flaws}()},
\code{\link{gitlog_to_hdsmj}()},
\code{\link{graph_to_dsmj}()},
\code{\link{parse_dv8_architectural_flaws}()},
\code{\link{parse_dv8_clusters}()},
\code{\link{transform_dependencies_to_sdsmj}()},
\code{\link{transform_gitlog_to_hdsmj}()}
}
\concept{dv8}
\concept{edgelists}
