% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git.R
\name{transform_gitlog_to_temporal_network}
\alias{transform_gitlog_to_temporal_network}
\title{Create time-ordered contribution network}
\usage{
transform_gitlog_to_temporal_network(
  project_git,
  mode = c("author", "committer"),
  lag = "one_lag",
  weight_scheme_function = weight_scheme_sum_edges
)
}
\arguments{
\item{project_git}{A parsed git project by \code{\link{parse_gitlog}}. The
name column will be used to label nodes.}

\item{mode}{author, committer}

\item{lag}{either the string "one_lag" or "all_lag". See \code{\link{temporal_graph_projection}}}

\item{weight_scheme_function}{the weight scheme function. See \code{\link{temporal_graph_projection}}}
}
\description{
Create a collaboration network as described by Joblin et al.
where an edge from developer A to developer B is created if A modifies a
file, and B modifies it chronologically immediately after. Note contrary
to the paper this definition is for files, not functions, and the weight
of the edges is the number of changes to a file, not churn.
}
\references{
M. Joblin, W. Mauerer, S. Apel,
J. Siegmund and D. Riehle, "From Developer Networks
to Verified Communities: A Fine-Grained Approach,"
2015 IEEE/ACM 37th IEEE International Conference on
Software Engineering, Florence, 2015, pp. 563-573,
doi: 10.1109/ICSE.2015.73.
}
\seealso{
Other edgelists: 
\code{\link{transform_commit_message_id_to_network}()},
\code{\link{transform_cve_cwe_file_to_network}()},
\code{\link{transform_dependencies_to_network}()},
\code{\link{transform_dependencies_to_sdsmj}()},
\code{\link{transform_gitlog_to_bipartite_network}()},
\code{\link{transform_gitlog_to_entity_bipartite_network}()},
\code{\link{transform_gitlog_to_entity_temporal_network}()},
\code{\link{transform_gitlog_to_hdsmj}()},
\code{\link{transform_reply_to_bipartite_network}()},
\code{\link{transform_temporal_gitlog_to_adsmj}()},
\code{\link{transform_understand_dependencies_to_network}()}
}
\concept{edgelists}
