% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dv8.R
\name{transform_gitlog_to_hdsmj}
\alias{transform_gitlog_to_hdsmj}
\title{Transform parsed git repo into a history dsm.json file.}
\usage{
transform_gitlog_to_hdsmj(project_git, hdsmj_path, is_sorted = FALSE)
}
\arguments{
\item{project_git}{A parsed git project by \code{\link{parse_gitlog}}.}

\item{hdsmj_path}{the path to save the history dsm (*-hdsm.json).}

\item{is_sorted}{whether to sort the variables (filenames) in the hdsm.json file (optional).}
}
\description{
Converts a gitlog table into an *-hdsm.json.
In the hdsm.json, the Variables are all files/methods or any variables under analysis
(rows/columns in dependency matrix) and the Cells (matrix cell) contain all the relations of
 variable (src & dest) pairs. The Co-change is the number of times the src & dest were committed together.
Note that the co-change between a file and its renamed variant will not be considered
using this function, so those cells won't appear in the final *-hdsm.json.
}
\seealso{
\code{\link{parse_gitlog}} to get a table of a parsed git project needed as input into \code{\link{transform_gitlog_to_hdsmj}},
\code{\link{transform_temporal_gitlog_to_adsmj}} to perform a similar transformation into a *-dsm.json using a temporal gitlog,
\code{\link{transform_dependencies_to_sdsmj}} to perform a similar transformation into a *-dsm.json using dependencies from Depends,
\code{\link{graph_to_dsmj}} to generate a *-dsm.json file.

Other edgelists: 
\code{\link{transform_commit_message_id_to_network}()},
\code{\link{transform_cve_cwe_file_to_network}()},
\code{\link{transform_dependencies_to_network}()},
\code{\link{transform_dependencies_to_sdsmj}()},
\code{\link{transform_gitlog_to_bipartite_network}()},
\code{\link{transform_gitlog_to_entity_bipartite_network}()},
\code{\link{transform_gitlog_to_entity_temporal_network}()},
\code{\link{transform_gitlog_to_temporal_network}()},
\code{\link{transform_reply_to_bipartite_network}()},
\code{\link{transform_temporal_gitlog_to_adsmj}()},
\code{\link{transform_understand_dependencies_to_network}()}

Other dv8: 
\code{\link{dependencies_to_sdsmj}()},
\code{\link{dv8_clsxb_to_clsxj}()},
\code{\link{dv8_clsxj_to_clsxb}()},
\code{\link{dv8_depends_to_sdsmj}()},
\code{\link{dv8_dsmj_to_dsmb}()},
\code{\link{dv8_hdsmb_sdsmb_to_mdsmb}()},
\code{\link{dv8_mdsmb_to_flaws}()},
\code{\link{gitlog_to_hdsmj}()},
\code{\link{graph_to_dsmj}()},
\code{\link{parse_dv8_architectural_flaws}()},
\code{\link{parse_dv8_clusters}()},
\code{\link{transform_dependencies_to_sdsmj}()},
\code{\link{transform_temporal_gitlog_to_adsmj}()}
}
\concept{dv8}
\concept{edgelists}
