% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dv8.R
\name{transform_dependencies_to_sdsmj}
\alias{transform_dependencies_to_sdsmj}
\title{Transform parsed dependencies into a structural dsm.json file.}
\usage{
transform_dependencies_to_sdsmj(
  project_dependencies,
  sdsmj_path,
  is_sorted = FALSE
)
}
\arguments{
\item{project_dependencies}{A parsed depends project by \code{\link{parse_dependencies}}.}

\item{sdsmj_path}{the path to save the structural dsm (*-sdsm.json).}

\item{is_sorted}{whether to sort the variables (filenames) in the sdsm.json file (optional).}
}
\description{
Converts table of dependencies from \code{\link{parse_dependencies}} into an *-sdsm.json.
In the sdsm.json, the Variables are all files/methods or any variables under analysis
(rows/columns in dependency matrix) and the Cells (matrix cell) contain all the relations of
 variable (src & dest) pairs.
}
\seealso{
\code{\link{parse_dependencies}} to get a table of parsed dependencies needed as input into \code{\link{transform_dependencies_to_sdsmj}},
\code{\link{transform_gitlog_to_hdsmj}} to perform a similar transformation into a *-dsm.json using a gitlog,
\code{\link{transform_temporal_gitlog_to_adsmj}} to perform a similar transformation into a *-dsm.json using a temporal gitlog,
\code{\link{graph_to_dsmj}} to generate a *-dsm.json file.

Other edgelists: 
\code{\link{transform_commit_message_id_to_network}()},
\code{\link{transform_cve_cwe_file_to_network}()},
\code{\link{transform_dependencies_to_network}()},
\code{\link{transform_gitlog_to_bipartite_network}()},
\code{\link{transform_gitlog_to_entity_bipartite_network}()},
\code{\link{transform_gitlog_to_entity_temporal_network}()},
\code{\link{transform_gitlog_to_hdsmj}()},
\code{\link{transform_gitlog_to_temporal_network}()},
\code{\link{transform_reply_to_bipartite_network}()},
\code{\link{transform_temporal_gitlog_to_adsmj}()},
\code{\link{transform_understand_dependencies_to_network}()}

Other dv8: 
\code{\link{dependencies_to_sdsmj}()},
\code{\link{dv8_clsxb_to_clsxj}()},
\code{\link{dv8_clsxj_to_clsxb}()},
\code{\link{dv8_depends_to_sdsmj}()},
\code{\link{dv8_dsmj_to_dsmb}()},
\code{\link{dv8_hdsmb_sdsmb_to_mdsmb}()},
\code{\link{dv8_mdsmb_to_flaws}()},
\code{\link{gitlog_to_hdsmj}()},
\code{\link{graph_to_dsmj}()},
\code{\link{parse_dv8_architectural_flaws}()},
\code{\link{parse_dv8_clusters}()},
\code{\link{transform_gitlog_to_hdsmj}()},
\code{\link{transform_temporal_gitlog_to_adsmj}()}
}
\concept{dv8}
\concept{edgelists}
