% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{temporal_graph_projection}
\alias{temporal_graph_projection}
\title{Apply a temporal graph projection}
\usage{
temporal_graph_projection(
  graph,
  mode,
  weight_scheme_function = NULL,
  timestamp_column,
  lag = c("one_lag", "all_lag")
)
}
\arguments{
\item{graph}{A bipartite network (the same pair of nodes can have multiple edges)}

\item{mode}{Which of the two nodes the projection should be applied to. TRUE or FALSE}

\item{weight_scheme_function}{When not specified, bipartite_graph_projection will return an intermediate
projection table specifying the deleted node, from_projection, to_projection, from_weight, and to_weight.
This table also contains (N choose 2) rows for every "deleted_node" in the original graph.
When receiving as parameter \code{\link{weight_scheme_sum_edges}} or
\code{\link{weight_scheme_count_deleted_nodes}}, the final projection table will be returned instead.}

\item{timestamp_column}{a string containing the name of the timestamp variable}

\item{lag}{a string specifying either "one_lag" or "all_lag".}
}
\value{
A graph projection.
}
\description{
Apply a temporal graph projection
}
\references{
M. Joblin, W. Mauerer, S. Apel,
J. Siegmund and D. Riehle, "From Developer Networks
to Verified Communities: A Fine-Grained Approach,"
2015 IEEE/ACM 37th IEEE International Conference on
Software Engineering, Florence, 2015, pp. 563-573,
doi: 10.1109/ICSE.2015.73.
}
