% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.R
\name{subset_gof_class}
\alias{subset_gof_class}
\title{Subset GoF Classes}
\usage{
subset_gof_class(gof_patterns)
}
\arguments{
\item{gof_patterns}{A table of parsed GoF Patterns
obtained from \code{\link{parse_gof_patterns}}.}
}
\description{
The \code{\link{write_gof_patterns}} contains not only
the participation of a class in a GoF Pattern, but also
the participation of methods and variables when applicable.
To distinguish a row entry among class, method or variable,
we must subset the role names that are associated to classes.
This information can be obtained by inspecting the source code
of a similar tool to pattern4 by Tsantalis.
}
\details{
More specifically, every pattern that pattern4.jar can identify is
defined as a PatternDescriptor in DPD4Eclipse/src/gr/uom/java/pattern
/PatternGenerator.java (see: https://github.com/tsantalis/DPD4Eclipse).

E.g. The PatternDescriptor Decorator has rowNameList.add("Component");
rowNameList.add("Decorator"); Therefore, in the XML output by pattern4.jar,
it is guaranteed when (pattern_name == "Decorator" & role_name == "Component") or
(pattern_name == "Decorator" & role_name == "Decorator").

By following this process, a list of role names can be defined to subset the table
to only contain classes.

Note pattern4 executes in bytecode, hence the classes are identified by their namespace.
Refer to \code{\link{query_src_text_namespace}} to obtain a table to map namespace classes
 to filepaths.
}
