% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jira.R
\name{parse_jira_rss_xml}
\alias{parse_jira_rss_xml}
\title{Parse Jira Issue RSS XML Feed}
\usage{
parse_jira_rss_xml(jira_issues_folderpath)
}
\arguments{
\item{jira_issues_folderpath}{path to folder of XML issues (see references in this function docs)}
}
\value{
A data.table containing the parsed XML feed (not the fields are not exhaustive. Refer
to the raw data for all possible fields.)
}
\description{
This function can be used to parse our prior TSE JIRA Issue Feed supplemental material.
For new JIRA datasets, please refer to \code{\link{parse_jira}}.
}
\references{
W. Mauerer, M. Joblin, D. A. Tamburri, C. Paradis, R. Kazman and S. Apel,
"In Search of Socio-Technical Congruence: A Large-Scale Longitudinal Study,"
in IEEE Transactions on Software Engineering, vol. 48, no. 8, pp. 3159-3184,
1 Aug. 2022, doi: 10.1109/TSE.2021.3082074.
}
\seealso{
Other parsers: 
\code{\link{build_understand_project}()},
\code{\link{export_understand_dependencies}()},
\code{\link{parse_bugzilla_perceval_rest_issue_comments}()},
\code{\link{parse_bugzilla_perceval_traditional_issue_comments}()},
\code{\link{parse_bugzilla_rest_comments}()},
\code{\link{parse_bugzilla_rest_issues_comments}()},
\code{\link{parse_bugzilla_rest_issues}()},
\code{\link{parse_commit_message_id}()},
\code{\link{parse_dependencies}()},
\code{\link{parse_dv8_clusters}()},
\code{\link{parse_gitlog}()},
\code{\link{parse_jira_latest_date}()},
\code{\link{parse_jira}()},
\code{\link{parse_mbox}()},
\code{\link{parse_nvdfeed}()},
\code{\link{parse_understand_dependencies}()}
}
\concept{parsers}
