% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jira.R
\name{parse_jira_latest_date}
\alias{parse_jira_latest_date}
\title{Parse JIRA current issue}
\usage{
parse_jira_latest_date(json_folder_path)
}
\arguments{
\item{json_folder_path}{path to save folder containing JIRA issue and/or comments json files.}
}
\value{
The name of the jira issue file with the latest created date that was created/downloaded for
use by the Jira downloader refresher
}
\description{
Returns the file containing the most current issue in the specified folder.
}
\details{
The folder assumes the following convention: "(PROJECTKEY)_(uniextimestamp_lowerbound)_(unixtimestamp_upperbound).json"
For example: "SAILUH_1231234_2312413.json". This nomenclature is defined by \code{\link{download_jira_issues}}.
}
\seealso{
Other parsers: 
\code{\link{build_understand_project}()},
\code{\link{export_understand_dependencies}()},
\code{\link{parse_bugzilla_perceval_rest_issue_comments}()},
\code{\link{parse_bugzilla_perceval_traditional_issue_comments}()},
\code{\link{parse_bugzilla_rest_comments}()},
\code{\link{parse_bugzilla_rest_issues_comments}()},
\code{\link{parse_bugzilla_rest_issues}()},
\code{\link{parse_commit_message_id}()},
\code{\link{parse_dependencies}()},
\code{\link{parse_dv8_clusters}()},
\code{\link{parse_gitlog}()},
\code{\link{parse_jira_rss_xml}()},
\code{\link{parse_jira}()},
\code{\link{parse_mbox}()},
\code{\link{parse_nvdfeed}()},
\code{\link{parse_understand_dependencies}()}
}
\concept{parsers}
