% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jira.R
\name{parse_jira}
\alias{parse_jira}
\title{Parse JIRA Issues and Comments}
\usage{
parse_jira(json_folder_path)
}
\arguments{
\item{json_folder_path}{is a folder path containing a set of jira_issues as json files.}
}
\value{
A named list of two named elements ("issues", and "comments"), each containing a data.table.
}
\description{
Parses JIRA issues without or with comments contained in a folder following a standardized file nomenclature.
as obtained from \code{\link{download_jira_issues}}. A named list with two elements (issues, comments) is returned
containing the issue table and optionally comments table.
}
\details{
The following fields are expected on the raw data:

issuekey, issuetype, components, creator, created, description, reporter, status, resolution
resolutiondate, assignee, updated, comment, priority, votes, watches, versions, fixVersions, labels

which are the default parameters of \code{\link{download_jira_issues}}. If the `comment` field is
specified, then the comments table is included.

If a field is not present in an issue, then its value will be NA.
}
\seealso{
Other parsers: 
\code{\link{build_understand_project}()},
\code{\link{export_understand_dependencies}()},
\code{\link{parse_bugzilla_perceval_rest_issue_comments}()},
\code{\link{parse_bugzilla_perceval_traditional_issue_comments}()},
\code{\link{parse_bugzilla_rest_comments}()},
\code{\link{parse_bugzilla_rest_issues_comments}()},
\code{\link{parse_bugzilla_rest_issues}()},
\code{\link{parse_commit_message_id}()},
\code{\link{parse_dependencies}()},
\code{\link{parse_dv8_clusters}()},
\code{\link{parse_gitlog}()},
\code{\link{parse_jira_latest_date}()},
\code{\link{parse_jira_rss_xml}()},
\code{\link{parse_mbox}()},
\code{\link{parse_nvdfeed}()},
\code{\link{parse_understand_dependencies}()}
}
\concept{parsers}
