% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git.R
\name{parse_gitlog}
\alias{parse_gitlog}
\title{Parse Gitlog from Perceval}
\usage{
parse_gitlog(perceval_path, git_repo_path, save_path = NA, perl_regex = NA)
}
\arguments{
\item{perceval_path}{path to perceval binary}

\item{git_repo_path}{path to git repo (ends in .git)}

\item{save_path}{optional save path for .rds object}

\item{perl_regex}{a regex to filter git log entries using git's algorithm (efficient to return small datasets from large projects such as commit annotated issues)}
}
\description{
Parses the `.git` file in a github repository using the Perceval library.
}
\seealso{
Other parsers: 
\code{\link{build_understand_project}()},
\code{\link{export_understand_dependencies}()},
\code{\link{parse_bugzilla_perceval_rest_issue_comments}()},
\code{\link{parse_bugzilla_perceval_traditional_issue_comments}()},
\code{\link{parse_bugzilla_rest_comments}()},
\code{\link{parse_bugzilla_rest_issues_comments}()},
\code{\link{parse_bugzilla_rest_issues}()},
\code{\link{parse_commit_message_id}()},
\code{\link{parse_dependencies}()},
\code{\link{parse_dv8_clusters}()},
\code{\link{parse_jira_latest_date}()},
\code{\link{parse_jira_rss_xml}()},
\code{\link{parse_jira}()},
\code{\link{parse_mbox}()},
\code{\link{parse_nvdfeed}()},
\code{\link{parse_understand_dependencies}()}
}
\concept{parsers}
