% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mail.R
\name{make_mbox_reply}
\alias{make_mbox_reply}
\title{Create Mbox Reply String}
\usage{
make_mbox_reply(
  mailing_list,
  reply_from_author,
  reply_from_email,
  reply_to_author,
  reply_to_email,
  reply_cc_author,
  reply_cc_email,
  reply_datetime,
  timezone,
  reply_subject,
  reply_body
)
}
\arguments{
\item{mailing_list}{specific mailing list associated with this mbox data}

\item{reply_from_author}{name of sender (e.g. Firstname Lastname)}

\item{reply_from_email}{email of sender. (e.g. sender@domain.com --- will be formatted as <sender@domain.com>).}

\item{reply_to_author}{name of recipient (e.g. First Name Lastname)}

\item{reply_to_email}{email of recipient. (e.g. recipient@domain.com --- will be formatted as <recipient@domain.com>).}

\item{reply_cc_author}{name of one additional Cc'ed recipient (e.g. Firstname Lastname)}

\item{reply_cc_email}{email of one additional Cc'ed recipient (e.g. recipient2@domain.com --- will be formatted as <recipient2@domain.com>).}

\item{reply_datetime}{Date and time in the following format: 2023-02-11T09:30:00  (Be sure to add the capital T to separate date and time).}

\item{timezone}{The abbreviation of desired timezone (e.g: HST). For more information on date and timezone refer to POSIX doc. Enter: '?POSIXct' in console}

\item{reply_subject}{Subject of the email as a string}

\item{reply_body}{Body of the email as a string}
}
\value{
the content of the fake mbox you created returned as a string in mbox format
}
\description{
Used to create a single e-mail reply string in .mbox format.
See \code{link{create_mbox_from_replies}} to save it to disk.
}
\references{
For details, see \url{https://en.wikipedia.org/wiki/Email#Header_fields}.
}
