% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jira.R
\name{make_jira_issue}
\alias{make_jira_issue}
\title{Create JIRA Issue}
\usage{
make_jira_issue(
  jira_domain_url,
  issue_key,
  project_key,
  summary,
  description,
  issue_type,
  resolution,
  priority,
  status,
  labels,
  components,
  affects_versions,
  fix_versions,
  assignee_name,
  creator_name,
  reporter_name,
  comments = NULL
)
}
\arguments{
\item{jira_domain_url}{URL of JIRA domain (e.g. "https://project.org/jira")}

\item{issue_key}{issue key of JIRA issue (e.g. "PROJECT-68" or "GERONIMO-6723")}

\item{project_key}{key of the project that contains the JIRA issue (e.g. "SPARK" or "GERONIMO")}

\item{summary}{summary of the issue (e.g. "Site Keeps Crashing")}

\item{description}{more detailed description of issue (e.g. "The program keeps crashing because this reason")}

\item{issue_type}{type of JIRA issue (e.g. "New Feature", "Task", "Bug")}

\item{resolution}{name of resolution for issue (e.g. "Fixed")}

\item{priority}{the name of the priority of the issue (e.g. "Major", "Minor", "Trivial")}

\item{status}{status of issue for development (e.g. "In Progress")}

\item{labels}{the labels of the project (e.g. "message", "mail", "jira")}

\item{components}{list of components of issue (e.g. c("PS", "Tests"))}

\item{affects_versions}{list of affected versions (e.g. c("3.1.6", "4.1.0"))}

\item{fix_versions}{list of fixed versions (e.g. c("3.1.5", "4.0.0"))}

\item{assignee_name}{name of person the issue is being assigned to (e.g. "Joe Schmo")}

\item{creator_name}{name of creator of issue (e.g. "John Doe")}

\item{reporter_name}{name of reporter of issue (e.g. "Jane Doe")}

\item{comments}{character list where each element is a comment string (e.g. c("This is first comment", "This is second comment"))}
}
\value{
A list which represents the JIRA JSON in memory
}
\description{
Creates a single JIRA Issue as a list, which can be saved as a JSON with or without comments.
}
\seealso{
Other {unittest}: 
\code{\link{git_create_sample_log}()},
\code{\link{git_delete_sample_log}()}
}
\concept{{unittest}}
